# Какие таймауты должен понимать Wall-E

1. Таймауты на актуальность проверок – wall-e не должен смотреть на проверки, полученные слишком давно
2. Должен учитываться только статус проверки, полученный после починки или других действий с хостом
3. После изменения dns-записей Juggler-у потребуется до трёх 3 часов, чтобы обнаружить поломку
4. При добавлении нового хоста - таймаут на появление проверок (при отсутствии проверок сигнализируем владельцу)
5. При недоступности Juggler – удалять здоровье, которое старше определённого тайм-аута (чтобы в UI не сверкало)
6. Взаимозависимости проверок: при переходе активной проверки в crit и обратно требуется дать проверкам сети время на срабатывание

## Всегда работаем только с актуальными проверками
Актуальность проверок проверяется на основании заранее вычисленного timestamp, смысл которого в том, что: если проверка не обновилась до наступления этого ts, значит что-то сломалось. ts вычисляется при получении проверки:
1. Активные проверки, пассивные проверки, проверки стойки: время получения текущего состояния плюс два периода повтора из juggler-а.
2. Проверки hw-watcher-а: timestamp из метаданных + период запуска hw-watcher'а (10 мин) плюс период запуска пассивной проверки (пять минут) + время на просасывание через hw-watcher плюс период повтора из джагглера. Вычисляется так же вариант по пункту 1, выбирается меньшее из значений.
    Cмысл в том, что если проверка не обновляется (например, если сломался сам hw-watcher) то проверка может продолжать присылать старое состояние, которое hw-watcher записал в последний раз в БД. Вторая возможная проблема – из-за ttl джагглер может некоторое время посылать нам старое состояние, когда проверка уже сломалась и перестала отправлять обновления. По ts мы можем это своевременно отследить. Этот timestamp учитывает худший сценарий, чтобы уменьшить количество ложных срабатываний, в том числе возможную необходимость дожидаться регулярного пуша из джагглера (по идее, джагглер должен пушить в wall-e каждое изменение, но по факту в джагглере может "удачно" переехать мастер и нам придётся ждать лишние пять минут, пока новый мастер не решит отправить состояние "повторно").
3. Проверки нетмона: – время получения текущего состояния плюс два периода получения проверок из нетмона

## После починки хоста.
Мы хотим использовать только те состояния, которые произошли после манипуляций с хостом. Проверяем по `effective_timestamp`, его значение вычисляется таким образом чтобы "гарантировать", что событие случилось не раньше определённого момента. Слово "гарантировать" взято в кавычки, потому что в juggler есть ttl, который вычисляется динамически, и если пассивная проверка на сервере не работает, то мы об этом узнаем только после того, как истечёт ttl. При этом juggler будет периодически отправлять в Wall-E последнее состояние события.

Решить эту проблему можно добавлением timestamp в метаданные, что уже есть в проверках hw-watcher-а. В случае с активными проверками мы можем расчитывать на отказоусточивость джагглера.

1. для проверок hw-watcher-а effective_timestamp вычисляется как timestamp из метаданных - accuracy. Если это время больше, чем время манипуляций, то можно с уверенностью говорить, что событие произошло после манипуляций. Ожидаемый лаг в мониторинге – 13 минут.
2. проверки нетмона и стойки: effective_timestamp не влияет на логику Wall-E.
3. для остальных проверок вычисляется два значения:
   1. `status_mtime - overhead - accuracy`. Например, для UNREACH accuracy равен 60 сек. Это значение позволяет с уверенностью сказать, что новое состояние случилось после манипуляций, если состояние изменилось. Здесь велика вероятность того, что значение overhead будет слишком большим, как и значение accuracy, тогда сравнение даст нам ложный false. Но если сравнение даёт true, то это true true. Удачное стечение обстоятельств позволяет закончить мониторинг за 5 минут для пассивных проверок. Неудачное стечение обстоятельств обрабатывается по следующему варианту.
   2. `receive_timestamp - overhead - push-period - (2 * check-period) - accuracy`. Это значение позволяет с не некоторой уверенностью сказать, что текущее состояние было обнаружено после манипуляций, если состояние не изменено: если effective_timestamp больше, чем момент окончания манипуляций, то мы "вероятно" имеем состояние, полученное после манипуляций. Если состояние проверки изменилось, то за это время мы гарантировано получим новое состояние, если не получили – значит либо состояние не изменилось, либо проверка перестала работать.

Немного больше про "effective_timestamp" на основе "receive_timestamp". Если проверка перестала работать, то за это время (`time - effective_timestamp`) мы "должны бы" получить NO DATA от джагглера: TTL всех имеющихся проверок "должен быть" меньше, чем `push-period + 2*check-period`. Худший сценарий: ломаются все понгеры, ttl на UNREACHABLE равен 15 минут; если при этом "удачно" переедет мастер в джагглере, то NO DATA мы получим только через 20 минут; в самом худшем случае Wall-E успеет отправить в преднастройку или переналивку хост, которому достаточно было ребута. ttl для пассивных проверок, ориентировочно, 10 минут (`2 * check-period`), худший случай – мастер в джагглере "удачно" переезжает и NO DATA мы получаем через 15 минут. Нормальный сценарий: после ребута effective_timestamp для проверки UNREACHABLE пересекает границу за <=12 минут, для проверки ssh - за <=14 минут, для пассивных проверок ~20 минут. NB: ситуации, когда джагглер перестаёт отправлять данные в Wall-E, на эти значения не влияют, wall-e перестанет использовать старые проверки раньше, чем истекут любые из этих тайм-аутов.

## После изменения DNS-записей
Понадобится отдельно запоминать rename time и проверять такое условие: `status_mtime > rename_time or effective_timestamp > rename_time + 3-ЧАСА`. Это позволит быстро реагировать на изменение статуса проверки и связать это изменение с выполненым действием. Отсутствие же изменнний придёт прождать до победного конца.

В этот момент константа `3-ЧАСА` начинает выглядеть как динамический период для проверки. Если таких константа станет больше, то можно будет пересмотреть политику вычисления effective_timestamp – вычислять не сразу при получении проверки, а позднее, при использовании.

## Таймаут на появление проверок
Время перехода хоста из free в assigned или время переименования хоста + время на запуска кронячки в wall-e + время на выполнение этой кронячки, плюс время флаподава в pongerd + время выполнения пассивных проверок + время на просасывание через Juggler + период пуша проверок в Wall-E.

Почти все величины в этом уравнении берутся "на глаз". Как долго выполняется процесс, создающий проверки в juggler-е, сильно зависит от количества новых хостов, для которых надо добавить проверки.

## Удаление здоровья из UI
Происходит при недоступности данных в течение трёх периодов пуша в Wall-E (`3 * 5 мин`).

## Взаимозависимости проверок
Активные проверки зависят от проверок инфраструктуры (свич и стойка). Активные проверки должны учитываться только в том случае, если:
1. проверки инфраструктуры в статусе ОК
2. и `effective_timestamp` активной проверки больше, чем время перехода проверки инфраструктуры в текущее состояние (`status_mtime`).
3. и с момента `status_mtime` активной проверки прошло больше времени, чем лаг проверок инфраструктуры. Лаг нетмона равен окно для проверок + период получения проверок из нетмона. Лаг проверки стойки равен задержке флаподава в понгере, времени просасывания в джагглере и периоду пуша проверок в Wall-E. (NB: наверно, можно эти лаги проверок инфраструктуры встроить в их effective_timeout?)
