# Работа с VLAN-ами

Wall-E считает своей задачей отдавать в проект работоспособный сервер. Правильная настройка VLAN-ов входит в критерии работоспособности, поэтому при заведении проекта мы просим вас указать, заехал ли проект в MTN и какие VLAN-ы используются. Дальше начинается магия, которая вызывает много вопросов.

## Глоссарий
Есть несколько слов, значение которых надо знать, чтобы понимать, о чём мы говорим.
* L2, L3 – уровни сетевых протоколов согласно [модели OSI](https://en.wikipedia.org/wiki/OSI_model#Layer_architecture).
   * L1 – физический уровень: провод, оптика, радиоволны.
   * L2 – уровень, позволяющий обмениваться некими данными утройствам, имеющим соединение на физическом уровне. Примеры протоколов: ARP, MAC (ethernet, wi-fi, etc). В двух словах, отличается от L3 тем, что все данные получают все соединённые устройства.
   * L3 – сетевой уровень, позволяющий выполнять адресацию и маршрутизацию мужду участниками сети. На этом уровне появляются протоколы IP и ICMP.
   * Остальные уровни не используются в данном документе и не относятся к скоупу проблемы. Для общего развития: TCP и UDP – это L4; SSH, Telnet, HTTP – это L7.
* VLAN – виртуальная сеть, построенная внутри обычной. Это далеко не VPN, путать их не надо. VLAN-ы поддерживаются оборудованием на уровне L2 и практически являются просто дополнительным байтом, пристёгнутым к сетевому пакету. Некоторые L2-свичи позволяют изолировать друг от друга порты, подключенные в разные VLAN-ы, и в некоторых случаях "пристёгивать" и "отстёгивать" маркировку VLAN-а к пакетам прозрачно для пользователя, подключенного к порту.
* Очередь в датацентре. Большинство ДЦ вводились в эксплуатацию не единовременно, а частями. Эти части в основном изолируются друг от друга по энергообеспечению, охлаждению и по сети. Практически, "датацентр" – это адрес, а реальная группировка серверов в отказоустойчивые блоки – это очереди. Правда, здесь есть нюансы, но они непринципиальны для данного документа.
* TOR – Top Of Rack, коммутатор (свитч), который ставится в каждую стойку, к нему подключаются сервера из стойки.
* HBF – host base firewall. Решение, которое фильтрует трафик на сервере, а не в какой-то центральной точке. В отличие от старого решения, при котором трафик фильтровался через выделенные физические сервера - фаерволлы.

## MTN vs L3 vs L2
Для wall-e нет большой разницы, находятся ли хосты в L3-сегменте или в L2. Для Wall-E есть разница, заехали хосты в MTN или нет.
* L2 – самая старая схема (как минимум, из ныне существующих) построения сети в Яндексе. В каждой серверной стойке устанавливается коммутатор, который является "простым" L2-коммутатором. Проекты изолируются друг от друга с помощью VLAN-ов: каждый проект живёт в своём VLAN-е (иногда в нескольких). В каждую "очередь" устанавливается файрвол – физический сервер, через который проходит весь трафик очереди. Этот файрвол ограничивает доступы из одного VLAN-а в другой.
* L3 – схема, в которой стоечный коммутатор заменяют на роутер – L3-устройство. Этот роутер маршрутизирует сети из проектного VLAN-а в свой uplink. Это влияет на область распространения broadcast-пакетов и маршрутизацию, но как правило это не сильно влияет на то, как видит мир отдельно взятый хост.
* MTN - схема, в которой между стоечным роутером и центральным роутером очереди есть ещё несколько дополнительных уровней, забирающих на себя межстоечный трафик, чтобы разгрузить центральный роутер очереди. Эта схема сильно усложняет использование централизованного файрвола, поэтому в MTN используется hbf – файрвол работает на каждом хосте. Для сервиса MTN-схема отличается от L2/L3 не промежуточными уровнями и не hbf, а тем, что в ней отказались от проектных VLAN-ов, заменив их IPv6-сетями. Каждый проект имеет набор IPv6-сетей, которые содержат вшитый project-id, маршрутизаторы знают про этот project-id и пропускают трафик только между сетями одного проекта. Для корректной работы с проектами, заехавшими в MTN, Wall-E требуется знать project-id (мы его называем hbf-project-id).

{% note warning %}

До сих пор ни для одного проекта не появилось способа надёжно отличать, в какой схеме работает (должен работать) каждый взятый отдельно сервер. Это значит, что в одном Wall-E-проекте:
* могут быть хосты из L2 и L3-сегментов (если они работают в одних и тех же VLAN-ах), потому что эти две схемы управляются одинаково
* не могут быть хосты из MTN и не-MTN (L2/L3), потому что MTN-схема управляет совершенно не так, как L2/L3

Конечно, это ограничение существует только для проектов, которым требуется автоматика по управлению VLAN-схемой и/или DNS-записями.

{% endnote %}

## Настройки VLAN-ов для не-MTN проекта

### {#vlan-security}
Список используемых (разрешённых) в проекте VLAN-ов могут задавать только администраторы Wall-E, пожалуйста обратитесь [в саппорт](https://st.yandex-team.ru/WALLESUPPORT) с просьбой добавить ваши VLAN-ы в настройки проекта. Пока нет доступного нам способа делать это автоматически, мы вручную проверяем, что VLAN действительно закреплён за проектом и только после этого добавляем его в настройки проекта, чтобы злоумышленник не смог заставить Wall-E переключить хосты в чужие VLAN-ы.

### {#vlan-permissions}
Для того, чтобы Wall-E смог переключать VLAN-ы, ему нужно выдать права на управление ими. Для этого достаточно прописать пользователя robot-walle@ здесь в списке владельцев VLAN-а, например, [на этой странице](https://racktables.yandex-team.ru/index.php?page=services&tab=vperms).

### VLAN-схема {#vlan-scheme}
В настройках проекта задаётся так называемая VLAN-схема. Её можно не указывать – тогда Wall-E не будет управлять VLAN-ами автоматически. Задать эту настройку может владелец проекта. Атрибутами VLAN-схемы являются основной (*нетегированный*) VLAN проекта (предполагается, что в проекте один основной VLAN во всех ДЦ) и дополнительные (*тегированные*) VLAN-ы, которые будут спущены всем хостам проекта. Дополнительными VLAN-ами здесь могут быть, например, fastbone-VLAN-ы, если их набор тоже постоянный и не зависит от точки физического подключения. В некоторых проектах дополнительными VLAN-ами становятся VLAN-ы для контейнеров, клиентские VLAN-ы и т.п.

Сейчас Wall-E умеет три VLAN-схемы: статическую, поисковую (search), MTN. Про статическую добавить больше нечего: это всё, что написано выше и не более того.

Поисковая VLAN-схема предполагает динамическое определение одного из дополнительных VLAN-ов – фастбонного, – на основе специально сформированной выгрузки. Используется два источника информации: ya.subr для IPv4-серверов и выгрузка [fastbone-vlan-map.json](https://racktables.yandex.net/export/fastbone-vlan-map.json) для IPv6-only серверов.

Задаётся VLAN-схема через UI или через консольный клиент:
`$ wall-e projects vlan-scheme set $project $vlan_scheme $native_vlan -e list,of,extra,vlans`

Схема MTN отличается тем, что в ipv6 адрес хоста зашивается project_id проекта. В этой схеме все хосты живут во VLAN-ах 333,700,688,788, где 333 и 700 – это хостовые backbone+fastbone (в этих VLAN-ах живут системные процессы), а 688 и 788 – "сервисные" backbone+fastbone (в этих VLAN-ах живут сервисы). Список VLAN-ов для этой схемы – статический, общий для всех. Проекты отличаются только по project-id. Включается mtn-схема установкой hbf-project-id для проекта через UI или через консольный клиент:
`$ wall-e projects hbf-project-id set $project $project_id -m "move to mtn"`

При выборе VLAN-схемы `MTN` в настройках проекта доступна опция `Create fastbone DNS records`, позволяющая также генерировать FQDN для взаимодействия серверов проекта через fastbone-интерфейс.

**Host-id for IP-addresses** - настройка, определяющая способ генерации IP (mac/hostname). Должна совпадать с настройкой `ya-netconfig-project-id-host-method` в конфиге наливки.

### Персональные настройки для сервера (для не-MTN проектов) {#extra-vlans}
Для любого сервера проекта можно задать любое количество дополнительных VLAN-ов, в дополнение к тем, которые уже заданы в настройках VLAN-схемы. Указывать можно только те VLAN-ы, которые разрешены в проекте. Настройку можно сделать через UI по кнопке "Изменить Extra VLAN'ы" или через консольный клиент такой командой:
`$ wall-e hosts extra-vlans {set|add|remove} $host list,of,vlans`

## Управление VLAN-ами и project-id {#vlan-switching}
Если в проекте не задана VLAN-схема, то Wall-E переключает VLAN-ы только по прямому указанию от владельца проекта: по кнопке "Переключить VLAN'ы" в UI или такой командой:
`$ wall-e hosts switch-vlans $hostname list,of,vlans`
При этом пользователь должен сам указать, какие VLAN-ы нужно применить (первый в списке будет назначен основным), указывать можно только те VLAN-ы, которые разрешены в проекте.

### {#automatic-vlan-switching}
Если в проекте задана VLAN-схема (в т.ч. MTN), то Wall-E автоматически переключает VLAN-ы или project-id в следующих ситуациях:
* Автоматическая перезагрузка сервера
* Переналивка сервера
* Преднастройка сервера в Eine (EaaS)
* Первичная настройка сервера (введение в эксплуатацию)
При этом переналивка сервера – это не только операция redeploy, сервер может быть переналит, например, при замене дисков, преднастройка может выполняться при замене памяти, и т.п. Таким образом, задание VLAN-схемы может быть полезно не только в случае, когда сервер перестал отвечать на пинги, но и при проблемах с железом.

Дополнительно, если в проекте задана VLAN-схема, становится доступна опция "синхронизации VLAN-ов" по запросу от пользователя: по кнопке "Переключить VLAN'ы" в UI (можно не указывать VLAN-ы) или такой командой:
`$ wall-e hosts apply-vlans $hostname`
Полезно, если VLAN-ы по какой-то причине разъехались, например, после преднастройки.

## Процесс переключения VLAN-ов
Wall-E всегда проверяет, что VLAN-ы, в которые он будет переключать хост, принадлежат проекту. Есть так называемые "общие" VLAN-ы: сервисный 542-й, в котором происходит преднастройка, и парковочный 999, в котором нет жизни. Wall-E разрешает переключать сервера в общие VLAN-ы, даже если в проекте не задана VLAN-схема (можно переключить сервер в эти VLAN-ы вручную), указывать эти VLAN-ы в списке разрешённых для проекта не нужно.

Переключение делается через racktables. Процесс такой:
* Сначала Wall-E проверяет, нужно ли переключать VLAN-ы. Если порт свича уже переключен в нужный VLAN, то Wall-E дожидается, пока настройка будет применена (синхронизирована) на свич и больше ничего не делает.
* Если же переключение требуется, то Wall-E дополнительно проверяет, настроены ли выбранные VLAN-ы на свиче. Для этого используется выгрузка [net-layout.xml](https://racktables.yandex.net/export/net-layout.xml), проверяется следующий критерий: существует хотя бы одна сеть (`<network>`), которая привязана к нужному VLAN-у (`<vlan vlan_id>`) в домене (`domain_id`), к которому привязан свич (`<switch name>`), к которому подключен сервер. Если привязку найти не получилось, то задача завершится с ошибкой вида ##VLAN 522 is not available in the domain of the sas1-s759##.
* После проверки Wall-E формирует команду на переключение, получается что-то вроде `native=$project_vlan&mode=$mode&allowed[]=$extra_vlans`.
   * `native` – основной VLAN проекта (без тега)
   * `mode` – если указан основной VLAN, то будет `access`, иначе будет `trunk`. Создать операцию без основного VLAN-а можно только через API Wall-E
   * `allowed[]` – дополнительные VLAN-ы. Если операция автоматическая, то в этот список попадают дополнительные VLAN-ы, указанные в настройках VLAN-схемы проекта, дополнительные VLAN-ы, указанные для хоста, а так же для поисковой VLAN-схемы – фастбонный VLAN.
* Сформировав и отправив команду, Wall-E ждёт, когда настройки из racktables синхронизируются в настройки свича. Обычно это занимает не больше двух минут.
* После того, как VLAN применится на порт свича, Wall-E ждёт, когда ractables выделит сеть для этого VLAN-а на этом свиче. Эта операция производится один раз при первом включении VLAN-а на свиче и занимает не слишком много времени. Больше времени занимает формирование выгрузки, которую мониторит Wall-E, но опять же, это только в первый раз. Если VLAN уже был включен на свиче, то сеть останется в выгрузке практически навсегда. Wall-E проверяет выгрузки [l3-tors.txt](https://racktables.yandex.net/export/l3-tors.txt) и [net-layout.xml](https://racktables.yandex.net/export/net-layout.xml). Если сеть не прорастёт в течение таймаута (3 часа), то пользователь увидит примерно такую ошибку: ##Network assigning has timed out for the following VLANs: 522##.
* Wall-E проверяет, что при переключении VLAN-ов с порта был убран project-id. Если по какой-то причине он не был убран, Wall-E выполняет переключение по процедуре, описанной ниже.

## Процесс переключения project-id
Переключение делается через racktables. Процесс такой:
* Сначала Wall-E проверяет, есть ли необходимость в переключении project-id. Если на порту свича уже включен правильный project-id, то Wall-E дожидается, пока настройка будет применена (синхронизирована) на свич и больше ничего не делает.
* Далее Wall-E включает/выключает project-id на порту. При включении project-id, racktables автоматически включает на этом порту VLAN-ы 333, 700, 688 и 788. Это VLAN-ы в которых "живут" все mtn-овские хосты, в настоящий момент кастомизации не предусмотрено.
* Отправив команду, Wall-E ждёт, когда настройки из racktables синхронизируются в настройки свича. Обычно это занимает не больше двух минут.
* Wall-E проверяет, что на порту включились правильные MTN VLAN-ы. Если по какой-то причине не включились – переключает по процедуре, описанной выше.

Это всё. Источником ошибок в этом процессе может быть racktables: если по какой-то причине система не может включить project-id или VLAN-ы, или если синхронизация настроек сломалась и занимает слишком много времени.

## Дополнительно
* Посмотреть список VLAN'ов, которые навешаны на хост в данный момент, можно командой [wall-e hosts get -c $host](../guide/hosts.md#host-get).
* [Ликбез по L3](https://clubs.at.yandex-team.ru/sysadmin/10327)
* [Физическое устройство сети Яндекса, часть 1](https://clubs.at.yandex-team.ru/noc/2844) (второй части пока не существует)
