# Wall-E Checks Bundle

Для удобства доставки проверок на сервере пользователь мы создали свой бандл. Бандлы проверок – это механизм, который использует [juggler-client](https://docs.yandex-team.ru/juggler/client/basics). Чтобы включить наш бандл, достаточно добавить `wall-e-checks-bundle` в конфигурационный файл juggler-client-а, либо установить deb-пакет с проверками `search/unstable/wall-e-checks-bundle` и настроить в клиенте поиск проверок в в `/var/lib/rtc/juggler.d/wall-e-checks-bundle/`. Подробности работы juggler-client-а описаны [в его документации](https://docs.yandex-team.ru/juggler/client/configs#bandly-proverok).

Для корректной работы juggler-client-а требуется [заказать дырку в фаерволе](https://docs.yandex-team.ru/juggler/client/migration#migration). Для корректной работы бандла, juggler-client должен быть запущен от непривилегированного пользователя (нельзя запускать проверки от рута).

{% note warning %}

Для того, чтобы начать пользоваться бандлом, необходимо обновить juggler-client до версии 2.2+ и **не** запускать его от рута.

{% endnote %}

Проверки используют [hw-watcher](https://wiki.yandex-team.ru/haas/services/hw-watcher/), он должен быть установлен на все сервера проекта. **При этом необходимо**, чтобы hw-watcher был сконфигурирован для работы с Wall-E - в противном случае может получиться так, что Wall-E и hw-watcher будут вдвоем лечить одни и те же диски / память. Процедура настройки hw-watcher для работы с Wall-E предельно проста и описана [здесь](https://wiki.yandex-team.ru/haas/services/hw-watcher/walle/).

Проверки должны быть включены в настройках проекта в Wall-E, для этого можно использовать встроенную схему автоматики (`wall-e-hw-checks`):
`$ wall-e projects automation-plot set <$project_id> wall-e-hw-checks -m 'enable hw-checks in $project_id'`

Аналогичное действие можно сделать через UI, достаточно выбрать схему автоматики "Wall-E hw-checks" под заголовком "Ограничения схемы проверок". Подробнее про схемы проверок и работу автоматики в Wall-E можно почитать [в документации](automation/general.md).

В данный момент бандл включает в себя следующие проверки:
* `walle_meta`: Отображает работоспособность проверок из бандла, а так же транслирует версию бандла и версию hw-watcher-а.
* `walle_memory`: Транслирует в Juggler результаты проверок hw_watcher по памяти.
* `walle_disk`: Транслирует в Juggler результаты проверок hw_watcher по дискам, добавляя немного своей логики, которая затем используется в Wall-E.
* `walle_link`: Транслирует в Juggler результаты проверок hw_watcher по скорости сетевого интерфейса.
* `walle_bmc`: Транслирует в Juggler результаты проверок hw_watcher по различным параметрам из bmc, например, уровень заряда батарейки.
* `walle_gpu`: Транслирует в Juggler результаты проверок hw_watcher для GPU, установленных в системе.
* `walle_reboots`: Транслирует в Juggler результаты проверок по количеству перезагрузок на сервере (сервер может перезагружаться не только через wall-e, он может перезагружаться, например, сам).
* `walle_tainted_kernel`: Транслирует в Juggler результаты проверок ядра Linux (если ядро в [tainted-режиме](https://www.kernel.org/doc/Documentation/oops-tracing.txt), сервер требуется перезагрузить).
* `walle_cpu`: Транслирует в Juggler результаты различных проверок CPU.
* `walle_cpu_capping`: Транслирует в Juggler наличие ограничения мощности на CPU из-за проблем с питанием.
* `walle_fs_check`: Транслирует в Juggler количество ошибок файловой системы.
* `walle_clocksource`: Определяет текущий используемые источник времени. Если используется медленный источник hpet, то проверка переходит в статус CRIT. Эта проверка не используется в Wall-E по умолчанию, её можно добавить в собственную [схему проверок](automation/checks.md#automation-plot-checks).

Статусы проверок:
* OK: проблем нет
* WARN: либо проверка не может выполниться, либо проверки встретила неподдерживаемую конфигурацию. Этот статус требует внимания разработчиков. Если в вашем проекте есть проверки с такими статусами – свяжитесь с нами.
* CRIT: хост сломан и Wall-E должен его починить. Если в проекте включена автопочинка, подключена схема автоматики, для хоста не установлено ограничение на применение требуемого для починки действия, а сам хост находится в статусе, допускающем автоматическую починку, то wall-e выполнит требуемое действие для починки хоста.

## Разработка
Разработка ведётся в аркадии, код проверок и тесты расположены в директории [infra/wall-e/checks](https://a.yandex-team.ru/arc/trunk/arcadia/infra/wall-e/checks).

Разработка ведётся командой [Wall-E](https://abc.yandex-team.ru/services/wall-e/), по всем вопросам можно обращаться на рассылку wall-e@yandex-team.ru или в нашу [очередь в трекере](https://st.yandex-team.ru/WALLESUPPORT), в случае срочной критической ситуации – [в телеграмм](https://telegram.me/joinchat/BvdM3T9IC0GFEcqdw--ArA).

## Метрики
В данный момент все метрики по проверкам из этого бандла строятся опосредованно – их рисует Wall-E. Панели с графиками доступны в UI Wall-E, имеется глобальная статистика, доступна также разбивка по проектам.

Сломанные проверки выведены на [дашборд в Juggler-е](https://juggler.yandex-team.ru/dashboards/wall-e-bundle/).

## API
Получить данные о проверках можно и через API, достаточно воспользоваться ручкой [https://api.wall-e.yandex-team.ru/v1/hosts](http://api.wall-e.yandex-team.ru/v1/hosts).

Более подробно об API читайте в соответствующей [документации](https://api.wall-e.yandex-team.ru).
