# Wall-E Cli

Wall-E.Cli это приложение на python3, которое позволяет получить доступ к API Wall-E и немного больше.

{% note warning %}

На текущий момент работает только с третьей версией Python

{% endnote %}

## Установка

{% note warning %}

Текущий рекомендуемый способ установки/использования cli - ya tool.

{% endnote %}

### Из ya tool

Последнюю версию cli можно найти в `ya tool wall-e`

### Из аркадии

`https://a.yandex-team.ru/arc/trunk/arcadia/infra/wall-e/client`
`svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/infra/wall-e/client`

Бинарные версии собираются в `bin/wall-e.exe/wall-e` и `bin/wl.exe/wl`. Чтобы не набирать этот длинный путь, можно прописать `bin/wall-e.exe` и `bin/wl.exe` в `$PATH`.

### Ubuntu
Перед установкой ставим все необходимые пакеты:
`$ sudo apt-get install python3-dev python3-pip python3-setuptools`

Далее ставим исходя из предпочтений:
* Установка в систему:
`$ sudo pip3 install -U -i https://pypi.yandex-team.ru/simple/ wall-e.client`

* Установка в home (если установить в home не получается из-за конфликтов с системными пакетами (pip очень плохо умеет разруливать зависимости), то тогда проще всего поставить в virtualenv):
`$ pip3 install --user -U -i https://pypi.yandex-team.ru/simple/ wall-e.client`

* Установка в virtualenv:
```
$ python3 -m venv wall-e.venv
$ source wall-e.venv/bin/activate
$ pip3 install -U -i https://pypi.yandex-team.ru/simple/ wall-e.client
```

### macOS
Установка в virtualenv:
```
$ python3 -m venv wall-e.venv
$ source wall-e.venv/bin/activate
$ pip3 install -U -i https://pypi.yandex-team.ru/simple/ wall-e.client
```


Если клиент уже установлен, то с помощью той же команды `pip install -U` можно обновить его до последней версии при наличии строк, указанных ниже, в файле `~/.pip/pip.conf`:
```ini
[global]
index-url = http://pypi.yandex-team.ru/simple/
trusted-host = pypi.yandex-team.ru
```


## Получение токена

Для выполнения read-only-запросов аутентификация не требуется, и запросы могут быть анонимными, но все деструктивные действия будут требовать, чтобы вам был разрешен доступ. Более подробно про авторизацию написано в разделе [Авторизация](guide/authorization.md).

Wall-E использует наш OAuth. Токен получается следующей командой:

```
$ wall-e access-token obtain
Please go to https://oauth.yandex-team.ru/authorize?response_type=code&client_id=9e9702c0b7f54152ac339989d9039ccd
Enter obtained confirmation code: 1234567
Access token has been successfully obtained.
```

Переходим по урлу и вводим полученный confirmation code.

После этого все ваши запросы будут приходить от вашего имени. Это можно проверить, заглянув в [аудитный лог](guide/audit_log.md):
```
$ wall-e hosts reboot $host
$ wall-e audit-log get --host-name $host
2014.09.02 11:56:57 [konishchev@] [reboot-host] [#100061004|sas1-2864.search.yandex.net] -> 2014.09.02 11:57:17 [completed]
```

Большая просьба тем, кто отправляет API-запросы из своих скриптов: не поленитесь и заведите себе робота ([https://wiki.yandex-team.ru/DIY/zombik](https://wiki.yandex-team.ru/DIY/zombik)), чтобы отправлять запросы от его имени - так нам впоследствии будет проще понять, кто именно и в каких объемах пользуется Wall-E. Получить токен для робота также просто:
`$ wall-e access-token get`

В отличие от `obtain` команда `get` не сохраняет полученный токен в CLI, а только выводит его на stdout.


## Работа с CLI

CLI представляет из себя иерархию команд:
`$ wall-e projects` - группирует команды для работы с проектами
`$ wall-e hosts` - группирует команды для работы с хостами
и т. п.

`$ wall-e hosts reboot $host` - выполняет конкретное действие над указанным хостом

`--help` тоже присутствует:
```
$ wall-e --help              # опции, общие для всех команд
$ wall-e hosts --help        # помощь по операциям над хостами
$ wall-e hosts reboot --help # помощь по конкретной операции
```

В каждом разделе данного руководства приводятся примеры команд, которые необходимо выполнить для выполнения того или иного действия в Wall-E.


## Режим коротких команд

Для тех, кто очень часто вручную набивает команды к Wall-E, будет удобен режим с короткими алиасами команд, в котором команда `wall-e hosts list --name sas1` сокращается до `wl h l -n sas1`. Режим коротких команд включается посредством использования команды `wl` вместо `wall-e`.


## Работа с CLI в скриптах

По умолчанию вся информация выводится в человекочитаемом виде: с разбиением по колонкам, отступами и т. п. При использовании Wall-E CLI в скриптах гораздо удобнее использовать опцию `-b`, которая делает вывод более пригодным для обработки утилитами типа `awk`.

К примеру, команда `wall-e hosts list` выведет:
```
  #              FQDN            State     Status   Task status          Config

100014   imgs30-108.yandex.ru   assigned    ready        -        web-ubuntu-12.04-dev
100017   imgs30-106.yandex.ru   assigned    ready        -        web-ubuntu-12.04-dev

> Listed 2 hosts. Total: 2.
```

а `wall-e -b hosts list`:
```
100014 imgs30-108.yandex.ru assigned ready - web-ubuntu-12.04-dev
100017 imgs30-106.yandex.ru assigned ready - web-ubuntu-12.04-dev
```


## Autocompletion

Активировать shell autocompletion можно командами:
* `eval "$(register-python-argcomplete wall-e)"`
* `eval "$(register-python-argcomplete wl)"`

Работает он с небольшой задержкой, т. к. по сути при каждой операции автодополнения дергает CLI - сделано это сейчас так потому, что с точки зрения разработки такое автодополнение реализуется в пару строк и совершенно не требует времени на сопровождение при добавлении новых опций.


## Работа с большим количеством хостов {#batch}

Иногда нужно применить какое-либо действие к большому количеству хостов. К примеру, поменять статус всем машинам в своем проекте. На данный момент конкретно такой операции в CLI нет, да и, возможно, никогда не будет, т. к., во-первых, CLI не резиновый, и все варианты операций, которые могут понадобится пользователям, в него не засунешь, а, во-вторых, как-то страшно давать человеку такую возможность, потому что в результате небольшой опечатки можно случайно сделать что-то непоправимое - поэтому хотелось бы, чтобы для выполнения всех ответственных действий CLI вынуждал человека подумать, а не предоставлял очень простое решение, которое можно сделать быстро и не задумываясь.

Как же тогда выполнять подобные действия? Очень просто:

Все команды, которые работают с хостами, принимают в качестве аргументов несколько хостов, а также могут считывать их список со стандартного ввода. Также в CLI присутствует параметр `-b`, который отключает лишнее форматирование, в результате чего вывод становится пригодный для фильтрации каким-нибудь `awk` и прочими стандартными утилитами.

Пример:
* Поменять статус у всех хостов в проекте с `dead` на `ready`:
  `$ wl -b h l -p $project -s dead -C name | wl h s ready`
* Имея список хостов в файле, перезагрузить только те из них, которые в данный момент имеют статус `dead`:
  `$ wl -b h lo -s dead -C name < hosts | wl h r`

**Примечание:** не забудьте, что клиент при листинге ограничивает количество выводимых хостов (в данный момент - 100), и если у вас их гораздо больше, то чтобы `wl h l` выдал все хосты, необходимо ослабить эти лимиты опцией `-L/--limit`.


## Работа с группами хостов {#groups}

Как правило, человек работает не со всеми хостами, которые зарегистрированы в Wall-E, а только с их подмножеством, для которых он является ответственным. Также часто возникают задачи вида "переналить XXX хостов, пачками по XX хостов в каждой". Для решения этих задач в версии 0.0.8 появились группы хостов.

Возьмем следующую задачу: у меня есть 5 хостов, которые я хочу переналить, одновременно переналивать можно не более двух. Я не могу просто взять и отдать их все в переналивку, т. к. нужно переналивать только группами по 2 хоста. Даже если бы у меня было 5000 хостов с возможностью переналивать одновременно по 50, я не могу отправить их все разом в переналивку, несмотря на то, что у Wall-E есть внутренние ограничения на максимальное количество одновременно переналиваемых хостов, потому что:
* Данные ограничения являются деталью реализации Wall-E и могут свободно меняться со временем;
* Если вдруг в процессе переналивки я пойму, что что-то делаю не так и захочу отменить переналивку, отправлять команду на отмену переналивки нужно будет сначала хостам, которые стоят в очереди, и только потом хостам, которые переналиваются в данный момент, иначе у меня возникнет состояние гонок с сервером Wall-E, когда я буду отменять переналивающиеся в данный момент хосты, а Wall-E, используя освободившиеся слоты, будет отправлять в переналивку хосты, которые сейчас стоят в очереди.

Для решения этих проблем (а также ряда других) в wall-e.client были добавлены группы хостов. Тут очень важно подчеркнуть, что __весь функционал групп хостов реализован исключительно на стороне клиента Wall-E__. Это важно помнить, когда вы будете создавать группы и производить операции над ними: если во время проведения какой-либо операции над группой вы будете производить какие-либо еще операции над машинами из этой группы или, к примеру, со своего домашнего ноутбука создадите точно такую же группу и отдадите команду на какую-либо операцию над ней, то Wall-E никак не сможет проверить ваши действия и сообщить вам о том, что вы выполняете конфликтующие действия, в результате чего, скорее всего выполнение запущенных команд завершится с ошибкой на одном или втором клиенте. Все это было сделано с целью упрощения серверной части, т. к. есть желание сделать ее функционал минимальным, насколько это возможно, чтобы можно было полностью покрыть его тестами и гарантировать правильность работы, а уже весь дополнительный и service-specific функционал (которого со временем будет требоваться все больше и больше) вынести в клиента.

Итак, приступим.

Создаем группу хостов (предполагается, что они уже добавлены в систему):
`$ wall-e host-groups create --name my --process-queue-size=2 --max-fail-percent=5 < hosts`

Группы создаются на машине, с которой запускается клиент Wall-E. Команда `host-groups show` явно нам об этом говорит:
```
$ wall-e host-groups show my
Host group 'my' (/Users/konishchev/.wall-e/host-groups/my.yaml):

hosts: [sas1-2866.search.yandex.net, sas1-3082.search.yandex.net, sas1-2864.search.yandex.net,
  sas1-3026.search.yandex.net, sas1-2868.search.yandex.net]
max_fail_percent: 5
process_queue_size: 2
```

На уровне клиента доступ к группам контролируется через flock (клиент Wall-E не даст вам производить одновременно несколько действий над одной и той же группой).

Итак, группа у нас есть. Теперь мы можем с ней работать. Например, посмотреть на текущее состояние ее хостов:
`$ wall-e hosts list --group my`

Остальные команды также понимают группы и проверяют, что вы случайно не заденете хост, который не принадлежит указанной группе:
`$ wall-e hosts force-status --group my sas1-3082.search.yandex.net ready`

Если же хочется сделать какое-либо действие над всеми хостами в группе, то для этого есть специальный флаг `--all`:
`$ wall-e hosts force-status --group my --all ready`

Теперь, зная все это, мы наконец-то можем переналить нашу группу хостов. Выполняем команду и наблюдаем, как клиент начинает переналивать машинки в соответствии с настройками, заданными при создании группы:
```
$ wall-e hosts redeploy --group my --all
Processing 'redeploy' task on group 'my'...
Processing host sas1-2864.search.yandex.net...
Processing host sas1-2866.search.yandex.net...
.......
```

Весь процесс переналивки группы контролируется исключительно клиентом: он отдает команды Wall-E, следит, чтобы в каждый момент времени переналивалось по 2 хоста и т. п. Если этот процесс прервать (убить процесс `wall-e`), то новые команды Wall-E никто не пошлет, и процесс переналивки не будет двигаться с места, пока вы не продолжите его со стороны клиента.

Продолжить любую асинхронную задачу, которая была начата клиетом (перезагрузка, переналивка) можно следующей командой:
```
$ wall-e host-groups process my
Processing 'redeploy' task on group 'my'...
The following hosts are in process: sas1-2864.search.yandex.net, sas1-2866.search.yandex.net.
...................................................................................................................................................................
Host 'sas1-2866.search.yandex.net' has completed.
Processing host sas1-2868.search.yandex.net...
................................................
Host 'sas1-2864.search.yandex.net' has completed.
Processing host sas1-3026.search.yandex.net...
........................................................................................................................................................
Host 'sas1-2868.search.yandex.net' has completed.
Processing host sas1-3082.search.yandex.net...
..
Host 'sas1-3026.search.yandex.net' has completed.
....................................................................................................................................................................................................................
Host 'sas1-3082.search.yandex.net' has completed.
The 'redeploy' task has completed. 5 hosts processed, 0 failed. Fail percent: 0.0
```

Отменить текущую задачу, назначенную группе, можно командой cancel (на самом деле, на данный момен не отменяет уже начавшиеся переналивки, а просто забывает о том, что данной группе назначено какое-либо действие над хостами):
`$ wall-e host-groups cancel my`
