# Soft Maintenance

Рекомендации по важному аспекту работы хорошо спроектированной CMS: возможность отдать хост в работу не перемещая всю информацию и не перенося инстансы на другие хосты.

## Problem space

Сейчас на кластере производится два вида работ, которые в короткий срок могут затронуть весь кластер:
* обновление свичей НОК-ами
* обновление ядра/прошивок на оборудовании

Эти процессы имеют общую черту: если делать их через CMS, которая переносит сервисы при запросах, то по завершениями процесса весь кластер будет переаллоцирован, то есть, каждый инстанс переедет на другой хост как минимум один раз.

Что отличает эти два процесса: они отличаются влиянием на хост.

Обновление свичей на самом деле никак не трогает хост. Тем не менее, хост будет недоступен в течение нескольких минут (10-15 максимум). Период работ при этом в районе часа: то есть после того, как cms разрешила работы, хост в течение часа станет недоступен на 10 минут.

Обновление ядра это ребут сервера. Он приводит к выключению хоста, сервисы придётся запускать заново. Это другой процесс и поэтому он явно отличается от ребута свича. Хост будет выключен на несколько секунд, но время недоступности сервиса зависит от скорости запуска ОС и инфраструктуры.

Обновление прошивок – это преднастройка хоста. Мы запускаем преднастройку без тестов, потому что не хотим внезапно починить какую-то застарелую проблему на всём кластере. тем не менее, эта процедура выполняется заметно дольше, чем ребут.

Возможно, какие-то сервисы хотят, чтобы в первом случае их инстансы не переезжали, а во втором – переезжали. А какие-то сервисы хотят, чтобы не переезжали во всех трёх случаях, потому что время переезда будет больше, чем время простоя без переезда.

Мы называем режим, когда инстансы остаются на хосте, режимом "Soft Maintenance". Это означает, что если мы хотим ребутнуть свич, то cms просто отдаст все хосты из стойки в работу, не расселяя инстансы, если это не приведёт к деградации сервиса.

Мы не просим, чтобы cms "всегда отдавала хосты не глядя". Но мы просим, чтобы CMS могла отдать хосты быстро, чтобы мы не блокировали работы НОК-ов. "Soft maintenance" при массовых ребутах и обновлении прошивок мы оставляем на усмотрение сервиса.

На текущий момент НОК-и делают ребуты свичей без уведомления CMS. Практически, это "принудительный soft maintenance", спущенный на сервисы снаружи, и он использует самый неудобный способ для снижения вероятности отказа сервиса: ручное согласование.

Мы просим сервисы поддержать "правильный Soft Maintenace" на стороне CMS, чтобы ребуты свичей могли проходить через CMS, а не через ручное согласование.

## Как это должно выглядеть
Ноки заводят "сценарий" в Wall-E. Этот сценарий идёт во все CMS, которые поддержали Soft Maintenance (на текущий момент мы договариваемся с крупными сервисами индивидуально) и заводит задачу на хосты, попавшие под работы. Когда все хосты получили подтверждение от CMS, Wall-E разрешает ребут свича.

Если за 30 минут не все хосты получили подтверждение, Wall-E запрещает ребут. Запрашиваются только хосты, которые находятся в assigned + ready. Если какие-то хосты находятся в починке или в maintenance, для них разрешение не запрашивается – считается, что оно не требуется.

После того, как ребут свича завершился или отменился, Wall-E возвращает хосты в assigned + ready с автопочинкой.

Отличительные особенности cms-задачи на ребут свича:
* action = TEMPORARY_UNREACHABLE
* у всех задач заполнено поле host_group_id и оно одинаковое. (этот момент пока что в разработке). Задачи у каждого хоста всё-таки индивидуальные.

## Гарантии
Начнём со статуса кво: сейчас такие работы проводят без уведомления автоматики сервиса, через ручное согласование. Это ручное согласование пока что никуда не уходит. Если возникают проблемы в процессе, мы откатываемся на этот вариант.

Мы просим от сервисов, чтобы CMS-API отпускала хосты для ребута свича за единицы минут. Мы даём timeout 30 минут, после чего работы на свиче отменяются. Если CMS слишком часто блокирует работы, мы идём к сервису и ищем способы улучшить этот момент. Наш способ давления в этом месте – мы оставляем за собой право вернуться к изначальному варианту (не ходить в cms сервиса), если не получается улучшиться.

С нашей стороны, мы обещаем время недоступности хоста 10-15 минут, в течение часа после подтверждения. Мы не выключаем хост на время ребута свича. Час набегает из тридцатиминутного тайм-аута: если одна cms отдала один хост сразу, а другая cms держала другой хост 29 минут, то мы получим примерно 45 минут от запроса первого хоста до восстановления сетевой связности после ребута свича. Плюс 15 минут на интеграции всех со всеми и мониторинг.
