# CMS API v1.3

## Изменения по сравнению с v1.2 {#changelog}
* Любые поля, отсутствующие в основной схеме, теперь по умолчанию разрешены. Это позволяет добавлять новые опциональные поля без обновления версии CMS-API. Системы, которые не знают, что делать с незнакомыми полями, должны просто игнорировать их.  Новые поля, которые научится отправлять Wall-E, будут добавляться в json-схему в виде опциональных полей (с гарантией на сохранение обратной совместимости) и в это описание.
* Добавлено опциональное поле "extra" в тело запроса на создание задачи в CMS. Wall-E может передавать в этом поле словарик с дополнительными параметрами задачи. Состав словарика зависит от типа и параметров задачи, любой описанный параметр может отсутствовать, сам словарик тоже может отсутствовать (мы стараемся не передавать его, если он пустой). Возможные данные:
  * для задачи типа "замена диска":
    * `slot` – физический слот, в который вставлен диск, подлежащий замене. Определяется hw-watcher-ом на основе эвристики, точность не гарантирована.
    * `serial` – серийный номер диска, подлежащего замене. Определяется hw-watcher-ом на основе данных от самого диска. Может не совпадать со значением из БОТ-а по формату и/или отличаться префиксом. Диск с таким серийным номером может отсутствовать в системе – если он не определяется или если он установлен в полку.
* Добавлены новые action'ы:
  * `repair-bmc` (починка модуля удаленного управления материнской платой)
  * `repair-overheat` (починка перегрева)
  * `repair-capping` (исправление заниженной частоты CPU из-за проблем с питанием)
  Если CMS не поддерживает новые действия, она может интерпретировать их как `profile` или реджектить их.

История изменения версий в бережно сохранена [в описании изменений](versions.md).

## 1. Wall-E хочет что-то сделать с хостом
Возможны варианты:
* Wall-E (точнее, кто-то из владельцев проекта) добавляет новый хост в проект
* Wall-E (кто-то из владельцев проекта) удаляет хост из проекта
* Wall-E или кто-то из владельцев проекта хотят провести какую-то операцию над хостом (reboot/profile/redeploy/etc).

Wall-E делает
```
POST $cms/tasks[?dry_run=true]
```

Request:
```
{
  "id": "$task_id",
  "type": "$type",
  "issuer": "$issuer",
  "action": "$action",
  "hosts": ["$host"],

  # Опциональные поля
  "comment": "some message from task author",
  "extra": {"key": "value"}
}
```

Response:
```
{
  "id": "$task_id",
  "hosts": ["$host"],

  # CMS сразу разрешает операции над данными хостами
  "status": "ok"
}
```
```
{
  "id": "$task_id",
  "hosts": ["$host"],

  # CMS приняла запрос и начала его обработку
  "status": "in-process"
  "message": "The following groups have too little number of working hosts: GROUP1 (1 from 3), GROUP2 (80 from 100), GROUP3 (50 from 60)"
}
```
```
{
  "id": "$task_id",
  "hosts": ["$host"],

  # CMS отклоняет запрос
  "status": "rejected",
  "message": "I will never give you these hosts. They are restricted for automated actions."
}
```

Значение `$task_id` уникально среди всех проектов. Если у вас несколько проектов (например, разбиты по локациям) и вы используете одну и ту же CMS, то можно расчитывать на то, что в неё никогда не придут два запроса одновременно с одним и тем же id но разными хостами.

Конечно надо помнить, что при запуске любой задачи (кроме предзаказов) владелец проекта может указать опцию `--ignore-cms`. Предполагается, что он знает, зачем он это делает. Если указывать эту опцию, CMS уведомлений не получит.

Прямо сейчас все запросы будут вида "один таск - один хост". Впоследствии "один таск - много хостов" может пригодиться в сценарии "Wall-E, хочу выключить вот эту стойку - сними нагрузку со всех хостов" (группировка по хостам позволит избежать миграций внутри стойки). CMS должна корректно работать в ситуации, когда задачи имеют пересекающееся множество хостов.

`type` может иметь два значения:
* `manual` - действие инициировано пользователем. Логин пользователя - значение поля `issuer` (например, `n-malakhov@`).
* `automated` - действие инициировано автоматикой. В данном случае `issuer` будет содержать внутренний идентификатор подсистемы, сгенерировавшей запрос (например, `wall-e`).

Если `status` - `in-process` или `ok`, то запрос считается принятым в обработку, и информация о данном запросе сохраняется где-то в недрах CMS. В случае `rejected` CMS ничего у себя не сохраняет.

`rejected` необходимо использовать только для тех запросов, которые не могут быть удовлетворены ни при каких условиях. Например:
* в запросе присутствуют хосты, которые не подконтрольны данной CMS.
* в одной задаче запрошена такая группа хостов, которая никогда не может быть выдана атомарно.

Во всех остальных случаях CMS должна возвращать статус `in-process`. При получении статуса `rejected` Wall-E прекращает работу с хостом и переводит его в статус `dead`.

Если в query string указан параметр `dry_run=true`, то CMS должна сэмулировать ответ на такой же запрос но без `dry_run=true`. Другими словами - принять решение относительно задачи (`ok|in-process|rejected`), но не сохранять результат в свою базу. Данный запрос (c `dry_run=true`) Wall-E будет посылать CMS, при запросах через API на reboot/redeploy хоста. С их помощью он будет проверять, стоит ли вообще инициировать операцию, и если CMS ответит отказом - будет сразу на уровне API отвечать пользователю отказом. Если ваша CMS устроена так, что, к примеру, вы не можете принять решение по задаче, не записав ее в БД, то рекомендуется выдавать оптимистичное оценочное решение, либо всегда `ok`. Но это не желательно, т. к. пользователи Wall-E API в таком случае будут получать отказ не сразу, а в виде зафейлившегося таска в Wall-E.


## 2. Wall-E начинает мониторить текущее состояние таска
Request:
```
GET $cms/tasks/$task_id
```

Response:
```
{
  "id": "$task_id",
  "hosts": ["$host"],

  # В процессе (например, CMS в данный момент производит миграцию инстансов, либо ждет, когда Wall-E закончит работу с другими хостами)
  "status": "in-process"
  "message": "The following groups have too little number of working hosts: GROUP1 (1 from 3), GROUP2 (80 from 100), GROUP3 (50 from 60)"
}
```
```
{
  "id": "$task_id",
  "hosts": ["$host"],

  # Таск был принят в обработку, но в процессе выяснилось, что выполнить его невозможно.
  "status": "rejected",
  "message": "Some error occurred."
}
```
```
{
  "id": "$task_id",
  "hosts": ["$host"],

  # Готово. Машины отданы в распоряжение Wall-E.
  "status": "ok"
}
```

Если `GET $cms/tasks/$task_id` вернет `404 Not found`, Wall-E создаёт новую задачу.

## 3. Как только Wall-E завершает работу над таском, он освобождает хосты, которые были для него выделены:
```
DELETE $cms/tasks/$task_id
```
Wall-E ожидает, что при попытке удаления несуществующей задачи CMS вернёт `404 Not Found`. В случае успеха wall-e ожидает получить `204 No content` или `200 Ok`.

## 4. Чтобы убедиться, что базы CMS и Wall-E не разъехались, Wall-E будет периодически получать список активных тасок:
```
GET $cms/tasks

Response:
{
  "result": [{
    "id": "task-1",
    "hosts": ["host1.yandex-team.ru"],
    "status": "ok"
  }, {
    "id": "task-2",
    "hosts": ["host2.yandex-team.ru"],
    "status": "in-process"
  }]
}
```

И удалять те, которые залипли.

## Обработка ошибок
Ошибки в обработке запроса сигнализируются с помощью HTTP-кодов. К примеру, в случае внутренней ошибки API должно вернуть `500 Internal Server Error` со следующим JSON-ответом:
`{"message": "An error message"}`

## JSON schema

### POST /tasks
**Request body:**
```json
{
    "title": "Add new task to CMS",
    "description": "Wall-E creates a new task for CMS, giving it a list of hosts and a task he wants to perform.",
    "type": "object",
    "properties": {
        "id": {
            "type": "string",
            "minLength": 1,
            "maxLength": 255,
            "description": "Task ID"
        },
        "type": {
            "enum": ["manual", "automated"],
            "description": "Task type"
        },
        "issuer": {
            "type": "string",
            "minLength": 1,
            "description": "Action issuer"
        },
        "action": {
            "enum": ["prepare", "deactivate", "power-off", "reboot", "profile", "redeploy", "repair-link", "change-disk"],
            "description": "Requested action"
        },
        "hosts": {
            "type": "array",
            "minItems": 1,
            "items": {
                "type": "string",
                "minLength": 1
            },
            "description": "Hosts to process the action on"
        },
        "comment": {
            "type": "string",
            "description": "optional comment from task's author"
        },
        "extra": {
            "type": "object",
            "description": "additional task parameters"
        }
    },
    "required": ["id", "type", "issuer", "action", "hosts"],
    "additionalProperties": true
}
```
**Query string:**
```json
{
    "dry_run": {
        "type": "boolean",
        "default": False,
        "description": "Don't make any changes, emulate request processing"
    }
}
```
**Response body:**
```json
{
    "title": "Task as it was created by CMS",
    "type": "object",
    "properties": {
        "id": {
            "type": "string",
            "minLength": 1,
            "maxLength": 255,
            "description": "Task ID must match requested task ID"
        },
        "type": {
            "enum": ["manual", "automated"],
            "description": "Task type, if present, must match requested task type"
        },
        "issuer": {
            "type": "string",
            "minLength": 1,
            "description": "Action issuer, if present, must match value from the request"
        },
        "action": {
            "enum": ["prepare", "deactivate", "power-off", "reboot", "profile", "redeploy", "repair-link", "change-disk"],
            "description": "Requested action, if present, must match value from the request"
        },
        "hosts": {
            "type": "array",
            "minItems": 1,
            "items": {
                "type": "string",
                "minLength": 1
            },
            "description": "Hosts to process the action on, must match value from the request"
        },
        "comment": {
            "type": "string",
            "description": "optional comment from task's author"
        },
        "extra": {
            "type": "object",
            "description": "optional task parameters"
        },
        "status": {
            "enum": ["ok", "in-process", "rejected"],
            "description": "Current status of CMS task"
        },
        "message": {
            "type": "string",
            "description": "Message for the current status"
        },
    },
    "required": ["id", "hosts", "status"]
}
```

**Extra attrs for change-disk tasks (example)**
```json
        "extra": {
            "type": "object",
            "description": "additional task parameters",
            "properties": {
                "slot": {
                    "type": "number",
                    "minimum": 0,
                    "description": "optional physical slot of a disk to replace."
                },
                "serial": {
                    "type": "string",
                    "description": "optional serial number of a disk to replace."
                }
            }
        }
```
### GET /tasks/<task_id>
**Response body:**
```json
{
    "title": "Task as it was created by CMS",
    "description": "Wall-E checks task that were created earlier. If no task was found, CMS should return 404 NOT FOUND.",
    "type": "object",
    "properties": {
        "id": {
            "type": "string",
            "minLength": 1,
            "maxLength": 255,
            "description": "Task ID must match requested task ID"
        },
        "type": {
            "enum": ["manual", "automated"],
            "description": "Task type"
        },
        "issuer": {
            "type": "string",
            "minLength": 1,
            "description": "Action issuer"
        },
        "action": {
            "enum": ["prepare", "deactivate", "power-off", "reboot", "profile", "redeploy", "repair-link", "change-disk"],
            "description": "Requested action"
        },
        "hosts": {
            "type": "array",
            "minItems": 1,
            "items": {
                "type": "string",
                "minLength": 1
            },
            "description": "Hosts to process the action on"
        },
        "comment": {
            "type": "string",
            "description": "optional comment from task's author"
        },
        "extra": {
            "type": "object",
            "description": "optional task parameters"
        },
        "status": {
            "enum": ["ok", "in-process", "rejected"],
            "description": "Current status of CMS task"
        },
        "message": {
            "type": "string",
            "description": "Message for the current status"
        },
    },
    "required": ["id", "hosts", "status"]
}
```
### DELETE /tasks/<task_id>
Empty request body, empty response document, response status code should be one of [200, 204, 404].
For code 200 response must be a valid JSON document.

### GET /tasks
**Response body:**
```json
{
    "title": "List of current tasks",
    "description": "Wall-E looks for staled tasks. CMS should return an object, containing a (possibly empty) list of tasks.",
    "type": "object",
    "properties": {
        "result": {
            "type": "array",
            "items": {
                "title": "Task as it was created by CMS",
                "type": "object",
                "properties": {
                    "id": {
                        "type": "string",
                        "minLength": 1,
                        "maxLength": 255,
                        "description": "Task ID must match requested task ID"
                    },
                    "type": {
                        "enum": ["manual", "automated"],
                        "description": "Task type"
                    },
                    "issuer": {
                        "type": "string",
                        "minLength": 1,
                        "description": "Action issuer"
                    },
                    "action": {
                        "enum": ["prepare", "deactivate", "power-off", "reboot", "profile", "redeploy", "repair-link", "change-disk"],
                        "description": "Requested action"
                    },
                    "hosts": {
                        "type": "array",
                        "minItems": 1,
                        "items": {
                            "type": "string",
                            "minLength": 1
                        },
                        "description": "Hosts to process the action on"
                    },
                    "comment": {
                        "type": "string",
                        "description": "optional comment from task's author"
                    },
                    "extra": {
                        "type": "object",
                        "description": "optional task parameters"
                    },
                    "status": {
                        "enum": ["ok", "in-process", "rejected"],
                        "description": "Current status of CMS task"
                    },
                    "message": {
                        "type": "string",
                        "description": "Message for the current status"
                    },
                },
                "required": ["id", "hosts", "status"]
            }
        }
    }
    "required": ["result"]
}
```
### Errors
**Response body:**
```json
{
    "title": "Error message",
    "description": "In case of server errors (5xx) server should return JSON document of this shape.",
    "type": "object",
    "properties": {
        "message": {
            "type": "string",
            "description:": "Error message"
        }
    }
    "required": ["message"]
}
```
