# Host FSM

Host FSM (finite-state machine) - конечный автомат для выполнения хост-задач.

## Общее описание

Основная задача подсистемы - при необходимости проведения каких-либо действий над хостом создать соответствующую задачу, разбитую на этапы, и проконтролировать ход ее выполнения внешними службами, такими как BOT, Setup, Eine и др.

## Задачи и их выполнение

Каждое действие представляет из себя задачу (Task), разбитую на подзадачи (Stage).

Подзадачи могут быть вложенными в друг друга, но обработчики будут вызываться только для самого нижнего уровня.

Реализация одноименных структур данных расположена [здесь](https://bb.yandex-team.ru/projects/NANNY/repos/wall-e/browse/walle/hosts.py).

#### Пример

Рассмотрим задачу перезагрузки контроллера управления материнской платой (BMC).

Можно выделить следующие подзадачи:

* проверка разрешения проводить эти действия. Сюда входит проверка лимитов, запрос к CMS проекта, проверка, что действие совершается в рабочее время;
* непосредственно перезагрузка BMC;
* логирование проведенной операции;
* ожидание сообщение от мониторинга о доступности хоста.

### Обработчики подзадач

Для каждой подзадачи регистрируются свои обработчики, причем их может быть несколько - на каждый возможный промежуточный статус выполнения.

Для регистрации используется функция `register_stage(name, handler, initial_status=None, cancellation_handler=None, error_handler=None)`, параметрами которой являются соответственно уникальное имя подзадачи, обработчик, а так же начальный статус и обработчики отмены и ошибок.

Существует вспомогательная функция `generate_stage_handler(status_handlers)`, которую можно передать в `register_stage` в качестве обработчика. `status_handlers` должен представлять из себя словарь, где ключем будет являться статус, а значением - конкретный вызываемый объект (функция), используемый при соответствующем статусе.

Результатом выполнения обработчика должно быть изменение состояния, то есть однократный вызов одной из функций (список не исчерпывающий):

* завершение текущей или родительской подзадачи (`complete_current_stage` или `complete_parent_stage`);
* завершение выполнения с ошибкой (`fail_current_stage`);
* повторная попытка обработки (`retry_current_stage`);
* изменение статуса (смена обработчика) и продолжение обработки текущей подзадачи (`commit_stage_changes`).

Все реализации конкретных Stage можно найти [тут](https://bb.yandex-team.ru/projects/NANNY/repos/wall-e/browse/walle/fsm_stages).

### Терминалы и терминаторы

Помимо "стандарных" способов завершения подзадач возможно завершать их с некоторым произвольным, но заранее зарегистрированым статусом (терминалом), которому соответствует определенный обработчик - терминатор, проще говоря - callback. Для этого используется функция `terminate_current_stage`.

Регистация производится с помощью функций `_register_terminal` или декоратора `_register_terminator`.

Для понимания, успешное и неуспешное завершение, повторная попытка и т.п. - это и есть терминалы SUCCESS, FAIL, RETRY, уже определенные в системе, но можно зарегистрировать свои.


