# Scenario FSM

Scenario FSM (finite-state machine) - подсистема выполнения заранее определенных сценариев над группами хостов.

## Общее описание

Подсистема предназначена для автоматизации рутинных регламентных операций над группами хостов, такими как ввод, переезд и т.п., посредством заранее определенных в Wall-E сценариев.

Код находится [здесь](https://bb.yandex-team.ru/projects/NANNY/repos/wall-e/browse/walle/scenario).

## Сценарии

Сценарии описываются классом `Scenario`, который хранит все необходимые данные и сериализуется в базу данных.

### Stage Info

Каждый сценарий изначально содержит в себе иерархический набор подзадач (Stage).

Особый интерес представляет поле `stage_info` класса `Scenario`, описываемое структурой `StageInfo`.
Там хранится информация о подзадачах сценария, включая их имена и параметры, а так же статус выполнения.

Метод `deserialize` класса `StageInfo` возвращает инициализированный объект текущей подзадачи.

## Подзадачи (Stages)

Рассмотрим все типы подзадач.

### Stage

Класc `Stage` является родительским классом для подзадач общего назначения - запрос прав, работа с трекером и т.п.

Наследники этого класса должны реализовать интерфейс `StageRunInterface`, который содержит единственный метод `run`, принимающий `stage_info` и сам сценарий, а возвращающий информацию о результате выполнения ("ошибка", "успех", "в процессе выполнения"), см. `MarkerStatus`.

### Host Stage

Класс `HostStage`, заготовка для всех подзадач над хостами.

Наследуется от интерфейса `HostStageRunInterface`, который так же содержит только метод `run` с такой же логикой, как и у `StageRunInterface`, но принимающим дополнительно конкретный хост.

### Scenario Root Stage

Все подзадачи сценария объединены в корневую подзадачу, представляющую собой класс `ScenarioRootStage`. Реализует интерфейс `StageRunInterface`.

Эта подзадача содержит в себе список дочерних подзадач (в том числе, возможно, опять `ScenarioRootStage`), выполнение которых происходит последовательно. Никакой дополнительной логики не содержит, в методе `run` лишь начинает исполнение очередной дочерней подзадачи.

### Host Root Stage

Класс `HostRootStage` реализует интерфейс `HostStageRunInterface` и очень похож по логике работы на Scenario Root Stage, но дочерние подзадачи могут быть только наследниками `HostStage`.

### Host Scheduler Stage

Специальная подзадача `HostSchedulerStage` содержит в себе `HostRootStage` и разбивает хосты на группы по определенному правилу (например, по датацентрам), и затем, последовательно для каждой группы, запускает выполнение Host Root Stage.

### Пример

Рассмотрим пример иерархии подзадач на примере сценария добавления хостов в RTC.

![flowchart](../../_assets/hosts_add_scenario.svg)

## Ошибки и борьба с ними

### Типы ошибок

Ошибки в сценариях делятся на три вида:

* RECOVERABLE: ошибки, которые возникли в сторонних системах. Если ошибка не прошла после нескольких повторных запросов, то Wall-E начинает отображать эту ошибку в UI и срабатывают мониторинги;

* USER_RECOVERABLE: ошибки, которые может исправить пользователь. Примеры таких ошибок – некорректный конфиг наливки или отсутствие у Wall-E доступа к dns-зоне для удаления/создания записей;

* FIXABLE: прочие ошибки, которые возникли внутри Wall-E.

### Обработка исключений

В случае возникновения ошибки, если Stage не может справиться с ней сам, генерируется исключение. Далее его обработка может происходить на одном из уровней:

* на уровне Host Scheduler Stage: накопитель, который отлавливает ошибку при обработке хоста, складывает ее в объект-коллектор и выбрасывает накопленное вверх, когда пройдётся по всем хостам. Таким образом, проблема с одним хостом не сломает обработку остальных хостов;

* на самом верхнем уровне, в который вылетают все ошибки. В метаинформацию сценария сохраняется сообщение, проверяется тип ошибки, делается retry, а так же увеличивается счетчик. Если он переполняется - ошибка становится видна в UI.
