# Reboot по IPMI и по SSH

## Как работает IPMI-reboot в Wall-E
В обычном случае Wall-E не делает power reset для сервера, потому что это по ряду причин довольно плохой вариант. Все действия Wall-E выполняет через [IPMI-Proxy](https://abc.yandex-team.ru/services/ipmiproxy/). Вместо простого ресета Wall-E выполняет такую процедуру:
1. Wall-E смотрит на проверку UNREACHABLE (ping), и определяет таймаут для операции выключения хоста: если хост доступен, то использует большой таймаут (10 минут), если хост недоступен, то используется меньший таймаут (30 секунд), чтобы не тратить время зря.
2. Wall-E делает попытку включить хост через ACPI (power soft). Это делается в первую очередь для того, чтобы не испортить рейд на сервере, если сервер в данный момент включен и работает. Без этого, после ребута рейд будет синхронизироваться несколько дней и производительность сервера резко упадёт.
3. После выполнения команды Wall-E проверяет статус хоста через ipmi (команда power status). Если хост выключился за указанный таймаут, то Wall-E начинает включать хост.
4. Если хост не выключился за отведённый таймаут, то Wall-E делает power off. Это более строгая команда, она выключает питание сервера. После этого Wall-E снова проверяет статус питания через power status, но таймаут меньший (30 сек)
5. Если за отведённый таймаут сервер не выключился, то Wall-E заводит в БОТ заявку на проблемы с IPMI ("не работает управление питанием")
6. После того, как сервер выключен, Wall-E включает сервер командой power on. Далее Wall-E проверяет состояние питания, таймаут на включение такой же, 30 сек. Если сервер не включился, создаётся заявка в БОТ.

Причины, по которым Wall-E не делает power reset, следуют из описания алгоритма:
1. power reset не позволяет определить, произошло выключение сервера, или нет, потому что через IPMI никакого состояние "до" и "после" нет.
2. если сделать power reset, то мы рискуем получить рассинхронизированный raid, который потом будет синхронизироваться примерно неделю.

## Как работает SSH-ребут
Wall-E умеет перезагружать сервер через ssh, с опциональным fallback-ом на IPMI. Для того, чтобы включить такой способ загрузки, нужно использовать переключатель ssh в api, cli или в UI. Переключатель принимает один параметр, доступные значения:
* `forbid` (по умолчанию) – запрещено использовать ssh для операции
* `only` – требуется использовать ssh для операции
* `fallback` – использовать ssh для операции, если по ssh не получилось – использовать ipmi

{% note info %}

Для того, чтобы ребут по ssh работал, Wall-E требуется доступ по ssh на сервер, [см ниже про доступы](#access).

{% endnote %}

Wall-E будет приходить на сервер под именем [robot-walle@](https://staff.yandex-team.ru/robot-walle) с ssh-ключом, публичная часть которого выложена на staff-е. Чтобы выполнить ребут, Wall-E запускает такие команды:
1. `cat /proc/sys/kernel/random/boot_id` – wall-e запоминает изначальный boot-id и сравнивает его с текущим значением, чтобы удостовериться, что сервер действительно перезагрузился
2. `sudo -n shutdown -r +1` – команда на перезагрузку. Используется `suhtdown -r +1` из-за того, что `reboot` мгновенно убивает sshd на хосте и wall-e не успевает корректно отключиться от хоста и ошибочно полагает неудачу при перезагрузке.
3. `cat /proc/sys/kernel/random/boot_id` – wall-e периодически проверяет, что сервер перезагрузился
4. Если сервер не перезагрузился в течение 10 минут, то Wall-E переходит к следующему действию: либо ребут через ipmi, либо перевод сервера в dead.

## Настройки и доступы {#access}
Как следует из списка команд, **Wall-E нужен беспарольный sudo для команды /sbin/shutdown** (не для ALL). Разрешение включается в настройках проекта Wall-E, переключателем "Reboot via ssh". Этот переключатель отправляет запрос в IDM, в результате роботу [robot-walle@](https://staff.yandex-team.ru/robot-walle) выдаётся [вот такая роль](https://idm.yandex-team.ru/system/walle#role=14124188,f-role-id=14124188), позволяющая выполнять `sudo shutdown`. Без этой роли Wall-E не позволит указать ssh в способе ребута при создании задачи.

Для того, чтобы доступы приехали на хосты, хосты должны быть подключены с CAuth и Wall-E должен быть в списке источников, [про настройку источников CAuth написано здесь](https://wiki.yandex-team.ru/intranet/cauth/sourcesfilter/).

Если операцию выполнить не получится, Wall-E либо попытается переключиться на IPMI, либо переведёт хост в dead.
