## Описание
Стейдж переключает VLAN-ы на порту в ожидаемую VLAN-схему. Сейчас понятие VLAN-схемы, которое используется в Wall-E, очевидно, морально устарело, но тем не менее: VLAN-схема предполагает одну из трёх сетевых схем:
* статически настроенный список VLAN-ов, один из который основной (не-тегированный)
* поисковая схема: backbone + fastbone, где backbone – это основной (не-тегированный) VLAN, а fastbone определяется динамически на основе выгрузки
* mtn – статически заданный набор VLAN-ов + mtn project id.

Подробности в [документации по работе с VLAN-ами](../../automation/vlans.md).

Стейдж делает чуть больше, чем просто включает VLAN-схему проекта, потому что есть также "сервисный VLAN", к тому же наливка может делаться либо в проектном VLAN-не, либо в сервисном – и стейдж поддерживает возможность изменить настройку без необходимости перезапускать задачу. Для того, чтобы указать, какую именно VLAN-схему требуется включить, стейдж принимает параметр "network target".

Поскольку для включения правильной схемы, приходится управлять двумя сущностями, стейдж делает обе задачи: переключает и VLAN-ы, и project-id. Есть три нюанса:
1. Если в конфигурации racktables вообще нет настройки для требуемого VLAN-а, то при попытке включить VLAN оно выдаёт какие-то невероятно странные ошибки. Требуется проверять, что конфигурация для VLAN-а описана, потому что из сообщения об ошибке этого непонятно.
2. Переключить VLAN недостаточно, требуется дождаться, пока ractables выделит подсеть для этого VLAN-а. Подсеть может быть уже выделена, но проверить и дождаться всё равно надо.
3. Если мы включаем порт в mtn, то достаточно установить project-id, VLAN-ы переключатся автоматически. Тем не менее, мы проверяем, что всё включено правильно. Если мы переключаем порт из MTN в обычный VLAN, то требуется только переключить VLAN-ы, project-id сбросится автоматически. При этом есть проблема: если сбросить project-id, а потом попытаться переключить VLAN-ы, то ractables выдаст ошибку. Это странное поведение, история описана в https://st.yandex-team.ru/NOCREQUESTS-4717 и https://st.yandex-team.ru/WALLE-1828.

После переключения проекта/vlan-ов ractables ставит изменения в очередь, потом собирает из очереди все изменения в новый конфиг для свича и заливает конфиг на свич. Racktables показывает, что изменения ещё не применены, добавляя флаг %%synced=True|False%% в информацию о текущем состоянии порта. Стейдж дожидается, пока сделанные изменения приедут на свич.

## Flowchart
Процесс разбит на этапы:
1. Сбор информации
2. Переключение проекта
3. Переключение VLAN-ов.

При этом в зависимости от того, в какую сторону происходит переключение (в mtn или из mtn), переключение проекта должно происходить до или после переключения VLAN-ов.

[Оригинальный документ](https://jing.yandex-team.ru/files/n-malakhov/vlans-stage.xml), можно импортировать в [draw-io](https://drawio.yandex-team.ru) и отредактировать (не забудьте перевыложить).


{% list tabs %}

- SVG

  ![flowchart](../../_assets/vlan_switching_stage.svg)

- PNG

  ![flowchart](../../_assets/vlan_switching_stage.png)

{% endlist %}