# DMC v2

## Текущая ситуация

  Тут частичная копипаста из [предыдущего драфта](https://wiki.yandex-team.ru/users/rocco66/walle-dmc-draft/#reshaemyeproblemy)
  * Текущие алгоритмы починки зашиты намертво в коде (частично [описаны тут](https://docs.yandex-team.ru/wall-e/automation/algorithm) и кастомизируются через множество if'ов в python коде, настроек проектов, конфигурационных файлах и деталей поломки. Нет гарантии, что документация не разъехалась с кодом. Скорее наоборот. Сложно поддерживать полноту документации в этом месте и кастомизацию алгоритма под нужды разных команд (RTC/MDS/YC и т.д.)
  * Поддержка DMC сложная из-за недостаточной прозрачности. А с увеличением кастомизации обещает стать ещё сложнее. Чтобы понять детали алгоритма починка (точный пайплайн, условия эскалации, текущее состояние починки) надо лезть в python код и делать довольно трудозатратные ментальные услилия, чтобы понять, как идёт эскалация правил и как мы пришли к текущему положению дел. Часто нужна информация о предыдущих состояниях проверок, предыдущих попытках починки и их результатах.
  * Сейчас вынесенное решение это одно поле в документе Host в монге и оно постоянно перезатирается. Что-то откладывается в логах, но логи ротируются, связаей с принятыми ранее решениями и сами логи куцые.
  * Код DMC работает не только внутри микросервиса DMC, но и внутри Task Stage'а monitor в микросервисе FSM
  
## Проблемы, которые мы не решаем

  * Всё, что выходит за рамки вынесения решения о починке:
    * конвертация decision в набор непосредственных шагов по починке (task stag'ей). Это работа DMC triage.
    * поддержка многозадачности
    * жизеннный цикл хоста
    
## Предлагаемое решение

### Настраиваемые правила починки

Вывернуть логику принятия решения наизнанку и дать возможность настраивать правила и реакции на починки в UI пользователю для отдельного automation plot'а. 
В automation plot появляется список из последовательно выполняющихся сверху вниз **Правил почики**.
[Ссылочка на примерную картинку](https://jing.yandex-team.ru/files/rocco66/dmcv2_1-full%20rules.drawio.png)
Есть три основных раздела правил:
  * Инфраструктурные правила. Здесь лежат особые правила, которые мы даём кастомизировать только частично или не даём кастомизировать совсем. Например реагировать ли на отсутствие netmon проверки и слать ли cms action на хосты при выпадении стойки.
  * Основная секция пользовательских правил починки. Здесь пользователь может выключать, менять содержимое и порядок правил.
  * Секция missing проверок, они должны идти после всех пользовательских проверок и содержать особые селекторы для выбора всех пассивных или всех hw watcher проверок.
  
Пользовательское правило починки содержит
[Ссылочка на примерную картинку](https://jing.yandex-team.ru/files/rocco66/dmcv2_1-repair%20rules.drawio.png) :
  + выключатель, которым можно отключить правило починки
  + набор селекторов. Если набор селекторов выдал True, то эта поломка будет чиниться этим правилом. Типы селекторов:
    + check_type - тип проверки. Надо уметь задавать несколько првоерок в одном правиле. Примеры: __ssh__, __disk__, __cpu__
    + check_status - статус проверки __crit__, __ok__
    + eine_code - eine коды поломки, переданные от hw watcher через метанданные проверки juggler
    + флаподав (stable_time?) - нужен для того, чтобы не чинить ssh сразу после поломки, а дать возможность задетектить поломку всей стойки 
    + history - нужен для того, чтобы реализовать лимиты на определённые действия над хостом. Например reboot, без привязки к конкретной проверке. Сейчас лимиты уже есть, но они реализованны отдельно и настраиваются в настройках проекта и в конфигах. Для работы этого селектора надо будет ходить в operation log, в который дополнительно предстоит начать писать дополниельные данные по которым можно вытащить определённые операции: check_type, task_args, eine_code и т.д.
    + комментарий со ссылкой на тикет по которому правило делалось

  + **repair workflow** - последовательность настраиваемых шагов от лёгких к всё более деструктивным. Состоит из нескольких последовательных **шагов**. Repair workflow - отдельная сущность, которую можно будет сохранить с именем и переиспользовать для нескольких правил починки в рамках одного automation plot'а. Каждый шаг содержит следующие вещи:
    + walle_action То, что валли будет делать для починки. Примеры: __reboot__, __profile__, __ITDC ticket__, __2nd_time_node__. Будут конвертированы в task/набор стейджей для работы в FSM.
    + cms_action - с каким action'ом идти забирать машину в CMS
    + repeat_count - сколько раз мы попытаемся этот шаг, прежде чем эскалируем на следующий шаг
    + interval - промежуток времени, за который мы будем анализировать сколько и какие попытки починки хоста мы делали в прошлом 
    + restrictions - дополнительные restriction'ы, которые будут проверяться для текущего хоста/проекта. Примеры: __AUTOMATED_PROFILE_WITH_FULL_DISK_CLEANUP__, __AUTOMATED_REDEPLOY__
    + task_params - набор параметров, передаваемых в генерируемую таску. Например теги и режим профилировки.
 
 Как будет работать эскалация в repair workflow:
 Делаем запрос к operation log по соответствующим фильтрам walle_action, interval, task_params и раскладываем их по шагам. Смотрим какие шаги уже были пройдены и берём первое свободный шаг на выполнение.
 
 Текущие пользовательские проверки будут сконвертированны в новые правила. Построение агрегатов juggler надо будет переписать так, чтобы они брали типы проверок из селекторов check_type новых правил.
 
### Написание новых правил
Новые правила пользователь может создавать сам, можем создавать и мы. Встаёт вопрос о том как доставить новое правило в пользовательские automation plot.
Решили сделать "эталонный" automation plot, куда мы будем сами добавлять правила и откуда правила будут копироваться во все другие automation plot'ы в отключенном виде. Включать их - обязанность владельцев automation plot'а. Копирование будет происходить руками командой walle cli.
При создании нового automation plot'а можно предлагать скопировать все правила из эталонного.
 
### Decision лог

[Ссылочка на примерную картинку](https://jing.yandex-team.ru/files/rocco66/dmcv2_1-repair%20log.drawio.png)
После прогона через все правила DMC надо сохранить результат этого прогона в базу для того, чтобы потом показывать в логе. Для уменьшения размера записи можно:
  - не хранить не сработавшие инфраструктурные правила
  - не хранить repair workflow не сработавших пользовательских правил (при обсуждении так же высказывалась мысль не хранить такие правила вообще)
  - обрезать хвост правил по сработавшему
  - не хранить health и wait decision'ы
  
Дополнительно запись в логе содержит:
  + время когда выполнялись предыдущие шаги, учитанные в принятии решения и ссылками на них в operation и decision логах. Эти данные надо будет хранить изначально в operation log'е
  + распаршенное состояние проверок

Лог храним в YDB, это безопасно потому что decision лог не принимает участия в прогоне правил. Нам нужен только operation log, а он остаётся в монге. Ключ (host(hash?), ts)

#### Примерные рассчёты объёма лога:
Число правил: 5 * 25 + 20 * 2 + 8 = 173
В каждом по 5 селекторов
15 шагов в логе repair workflow (меньше?)
итоговый размер записи: 172 * (100 + 5 * 50) + 15 * 1000 = 75200 байт
1100 хостов с активной задачей (проверка привела к запуску таски)
3 изменения decision с хоста в сутки
При условии, что историю храним за предыдущую неделю - насчитали 1.5 терабайта в неделю логов
За месяц если хранить не весь список рулов, а только тот который сматчился
(1100 * 3 * 30 * 75200) / (2 ** 30) = 6.93 Gb

### Хранение последнего прогона DMC в памяти с дополнительными данными

Нужно для того чтобы показывать wait решения, по которым было бы понятно что и ориентировочное время реакции. Храним  слепок лога в host вместе с доп полями. Отдаём дополнительно первым при запросе лога.

## Этапы реализации

Дельта с декомпозицией работ https://delta.yandex-team.ru/page/epad/page/ff9nuyevoqjzg51m

### Вывоз DMC из FSM
1. Начинаем писать в объект host счётчик рядом с decision для отслеживания работы screening'а в fsm.
2. Убираем dmc код из monitor'а, начинаем ориентироваться на decision, который сгенерировал screening. Свежесть решения отслеживаем по счётчику. 

### Миграция правил на новый DMC
1. Новый DMC записывает получившийся decision в host рядом со старым. Изначально просто decision=health
2. DMC triage начинает смотреть на оба decision сразу. Но на новое смотрит с фиксированным фильтром переключенных проверок. Из двух decision triage выбирает самое плохое (failed приоритетнее healthy, wait). Фильтр изначально пуст. Если оба failed, то берём старый decision
3. Выбираем самое низкоприоритетное правило. Реализуем его в новом DMC
4. Время на сверку результатов работы для определённой проверки
5. Включаем тип проверки в фильтре triage
6. Отключаем в старом dmc выбранное правило
7. Повторяем 3-6 пока не кончаться правила
  
## Дополнительно

Ссылочки на обсуждения:
  + <https://jing.yandex-team.ru/files/rocco66/IMG_20220608_171551.jpg>
  + <https://jing.yandex-team.ru/files/rocco66/IMG_20220608_171546.jpg>
  + <https://jing.yandex-team.ru/files/rocco66/IMG_20220608_171556.jpg>

Хорошо бы иметь возможность делать dry run запуски новых правил

Моменты на которые решили обратить внимание по итогам mini design review:
* проверить ещё разок объёмы пишущихся данных в YDB
* не давать слишком много кастомизации пользователям по крайней мере на первом этапе, а то будет сложно это всё поддерживать
* проверять не будет ли более деструктивного лечения на более низкоприоритетном правиле лечения. Возможно стоит прогонять все правила вооще, а не только до первого failed decision
