# FAQ

## Кто-то постоянно переналивает мои машины! Как посмотреть, кто это делает? {#faq-who-to-blame}

Все действия, которые Wall-E производит над машинами (автоматически или в результате запроса по API) попадают в [аудитный лог](guide/audit_log.md).

```
# Смотрим в продуктиве
$ wall-e audit-log get --host-name $host

# Смотрим в Testing
$ wall-e --testing audit-log get --host-name $host
```

## Wall-E не даёт переналить/ребутнуть/whatever хост, говорит "host is under maintenance by some-user@", что делать? {#faq-maintenance}

Не паниковать. Maintenance в данном случае – это про статус `manual`, а уведомление означает только что кто-то временно отключил автоматику для хоста, чтобы что-то с ним сделать вручную. Это рекомендуемое действие, [описанное в документации](guide/general.md#host-maintenance). Если владелец хоста закончил работу и не перевёл хост в статус `ready`, то можно запустить задачу, добавив флаг `--ignore-maintenance`. Лучше сначала убедиться, что коллега действительно завершил свою работу с сервером, чтобы не сломать сервер.

## Как посмотреть, какие ошибки Эксперт выдает в данный момент для хостов?

`$ wall-e hosts list --columns name,health`


## Отправил машину в перезагрузку/переналивку, а она уже целый час висит в состоянии power-off/powering-off/power-on/powering-on.

Как правило, это не является ошибкой. Скорее всего у машины в данный момент не работает IPMI, и Wall-E пришлось завести заявку в Бот на его починку. Как только заявка будет обработана, Wall-E попытается продолжить обработку поставленной ему задачи.


## Почему после перезагрузки хост так долго висит в статусе monitoring? {#faq-timeouts}
Это всё ради "безопасности". Wall-E хочет быть уверен, что хост действительно не сломался, или действительно починился после операции, поэтому дожидается результатов мониторинга, которые были получены заведомо после операции. В большинстве случаев люди ожидают, что зелёные квадратики в UI Wall-E означают, что всё в порядке "прямо сейчас", но на самом деле в системе полно задержек на всех уровнях и на любом уровне система может сломаться – и мы должны отличать задержку от поломки.

Много буков про то, какие таймауты откуда берутся, написано [на этой страничке](automation/timeouts.md). Если очень кратко, то Wall-E старается использовать status_mtime (это момент изменения состояния проверки), но если он на несколько секунд расходится с моментом, который wall-e считает моментом починки, то придётся ждать, пока выйдут все таймауты, которые занимают до 20-30 минут.

## При отправлении машин в переналивку они очень долго висят в статусе pending, прежде чем начнут переналиваться. Почему?

В статусе pending переналиваемая машинка может находиться по следующим причинам:
* Ее только что добавили и не прошло еще 30 секунд с момента ее добавления, чтобы она ушла в обработку (на данный момент это техническое ограничение, которое может быть без проблем убрано в будущем - пока просто не доходят до этого руки).
* Если машина висит дольше 30 секунд, то скорее всего просто заполнилась очередь на переналивку. Сейчас у нас выставлены довольно жесткие лимиты на максимальное количество одновременно переналиваемых хостов (пара десятков). Это сделано в первую очередь из-за того, что у [LUI](https://setup.yandex-team.ru/) есть проблемы с обработкой большого количества запросов на переналивку, а также из соображений паранойи, чтобы разом не разнести весь кластер. В будущем ограничение будет ослаблено или убрано.
* Если переналивка завершилась ошибкой, Wall-E в зависимости от ошибки может попробовать повторить попытку через некоторое время. В течение этого времени машина будет находиться в состоянии pending.


## При наливке через LUI: Почему Wall-E не может налить мою машину и выдает ошибку "Host's MAC addresses are invalid or it fails to boot from PXE. Failed MAC addresses: [macs]." {#faq-deploy-macs}

Скорее всего, сеть не настроена для наливки через LUI. Нужно либо [настроить сеть соответствующим образом](https://wiki.yandex-team.ru/haas/services/setup/network/), либо попробовать [наливаться в сервисном VLAN-е](guide/hosts.md#host-deploying)

## При наливке через LUI: Почему Wall-E не может налить мою машину и выдает ошибку "Host failed to boot from PXE: either its MAC addresses are invalid or it plugged into an invalid VLAN or there is a hardware problem." {#faq-deploy-ipxe}

Как говорится, подсказка в названии. Возможные варианты:
1. В БОТ-е хранятся неправильные MAC-адреса для хоста (если на хосте есть Wall-E.agent, то Wall-E обнаружит такое несоответствие и заведёт тикет на БОТ). Как проверить: зайти на хост по ssh и посмотреть MAC-адреса, сравнить их теми, которые видны в UI Wall-E
2. Неправильно настроена сеть: не настроен DHCP-relay или есть какие-то другие препятствия. Варианты решения – настроить сеть (для этого надо написать noqrec) либо [наливаться в сервисном VLAN-е](guide/hosts.md#host-deploying). Наливка в сервисном VLAN-е имеет не только положительные стороны – в процессе наливки хост получает адрес из другой сети, после возвращения в свою сеть IP-адрес хоста сменится. Как проверить: https://verify.haze.yandex.net/ или просто попробовать налиться из сервисной сети.
3. Хост не поддерживает iPXE. Обратитесь в очередь st:/WALLESUPPORT, если это так.
4. Что-то сломалось на хосте. Можно посмотреть процесс загрузки хоста через kvm. Можно отправить хост в преднастройку через Wall-E, пусть инженеры разбираются.

## Что означает ошибка "VLAN XXX is not available in the domain of the switch-name"? {#faq-no-vlan-in-domain}
Как правило это означает, что для этого VLAN-а нужно "нарезать сеть" в этом ДЦ/свиче. Если VLAN проектный, то это распространённая проблема, которая возникает при добавлении новых хостов в проект, если это 542-й VLAN – то это заведомо некорректная настройка со стороны нок-ов, этот VLAN должен быть везде. В любом случае, нужно обращаться к нокам в [st/NOCREQ](https://st.yandex-team.ru/createTicket?queue=NOCREQUESTS).

## Я добавил машинки в Wall-E час назад и у них до сих пор не появились результаты проверок, сколько времени это занимает?  {#faq-expert-initial}
Аналогично:
* Я добавил хост и начал сразу его переналивать, а после наливки он ушёл в dead
* Хосты из предзаказа попадали в dead после завершения подготовки
Скорее всего проверки ещё не создались. Wall-E создаёт в Juggler-е проверки самостоятельно, процесс периодический и занимает время, прямо пропорциональное количеству новых хостов, для которых надо создать проверки. Ожидаемое время прорастания проверок – примерно час. Больше букв про таймауты в Wall-E есть [на этой страничке](automation/timeouts.md).

Если новый хост не начал мониториться в течение трёх часов, то можно обращаться в саппорт-чатик wall-e в телеграмме.



## Я хочу, чтобы мои машинки были в базе Wall-E, но не хочу, чтобы он выполнял над ними какие-либо действия автоматически.
Можно запретить всю автоматику для конкретных машинок (см. [restrictions](guide/restrictions.md)).


## Как сделать так, чтобы никто не мог случайно ребутнуть/переналить мои машинки?
Можно запретить данные действия для конкретных машинок (см. [restrictions](guide/restrictions.md)).


## Как посмотреть текущие установленные лимиты в Wall-E? Отправил несколько сотен машин в наливку, а они наливаются пачками по 5 штук. {#faq-concurrent-tasks}
Лимиты есть разные:
* Есть [лимиты на автоматику](automation/limits.md).
* Еще есть лимиты по количеству активных задач на человека (их поменять может только [администратор Wall-E](guide/general.md#contacts) ) - там сейчас стоит 300, чтобы не положить наливку.
* По поводу 5 наливок за раз - это ограничение идет от [дефолтной CMS](cms/general.md) (см. описание `--ignore-cms` и `--max-busy-hosts`).


## Хост в преднастройке, Wall-E создал тикет в ITDC, я считаю, что это неправильно {#faq-eaas}

Если Wall-E отправил хост в eine преднастраиваться, а не переналиваться, то скорее всего хост преднастраивается в режиме eaas.
[Анонс с описанием этого режима](https://clubs.at.yandex-team.ru/eine/87/)
[Релевантная часть документации Wall-E](guide/hosts.md#host-profiling)

Опознать режим eaas просто: если Wall-E отправил хост в профиль flexy или common-firmware (или его производные common-firmware-*), то это eaas. Сотрудники ITDC при обработке тикета могут запустить другой профиль, нужно это учитывать и проверять историю.

В режиме EaaS починкой хоста занимается сама Eine, Wall-E отдаёт ей полный контроль. Если она не может переключить VLAN-ы, загрузить хост, выполнить тест, достучаться до IPMI – она создаёт тикеты в ITDC. В профилях flexy и common-firmware запускается также hw-watcher, так что если потребуется заменить память/диски/CPU – eine делает и это. Eine запускает тесты производительности CPU (linpack), тесты памяти (memcheck), тесты дисков (опционально – на запись), и если обнаруживает какие-то проблемы – создаёт заявки сама.

Wall-E может создать тикет в процессе преднастройки, только если хост не в eaas. Eine может создавать формализованные заявки на замену запчастей и самостоятельно перезапускать профиль. Отличить тикет, созданный самой eine, можно по тегу EaaS в тегах тикета – если тикет создал Wall-E, то такого тега не будет ([пример тикета от Wall-E](https://st.yandex-team.ru/ITDC-222096), [пример тикета от Eine](https://st.yandex-team.ru/ITDC-220337))

Если eine создала неправильный тикет – коллеги, которые придут разбираться с этим тикетом, это увидят. Тикеты от eine разбирает человек, который понимает, что это тикет от eine – потому что после починки железа требуется перезапустить профиль. Если eine создаёт неправильные тикеты – он это заметит.

Следить за процессом преднастройки хоста можно в eine, ссылка есть в UI Wall-E, на странице хоста.

## Wall-E создаёт тикеты на задачи, которые давно зафейлились, как это прекратить? {#faq-reports}
Есть несколько способов избавиться от тикетов, которые Wall-E создаёт каждый день.
Самый правильный способ – устранить ошибки, которые перечислены в тикете.
* Если в тикете есть хосты в статусе dead, то стоит [перевести их в статус ready](guide/hosts.md#host-force-status).
* Если в тикете есть хосты в статусе invalid, то с этим тоже [стоит разобраться](#faq-invalid).
* Если в тикете есть хосты, у которых возникла ошибка при обработке задачи, то стоит выяснить причину этой ошибки и устранить её. Если причина понятна из описания ошибки, то можно устранить её самостоятельно или завести тикет на смежную систему. Если причина непонятна или проблема в самом Wall-E, то можно завести тикет в [st:/WALLESUPPORT](https://st.yandex-team.ru/WALLESUPPORT)
* Если просто закрыть тикет, не устранив проблемы, то Wall-E создаст новый. Делать так не рекомендуется, потому что это бесполезно.

Второй вариант решения "проблемы" – запретить отчёты для своего проекта. Для этого достаточно сделать ["персональные настройки отчётов"](guide/reports.md) для своих проектов и указать флажок `--disable`, примерно так:
`$ wall-e projects reports set my-project MYQUEUE --disable -m 'disable reports from Wall-E, see st://WALLESUPPORT-XXX'`

## Wall-E создаёт тикеты и добавляет в них людей, которые никак не связаны с проектом. Почему? {#faq-report-people}
Как описано [в документации](guide/reports.md), Wall-E группирует проекты по параметрам отчётов (если параметры отчётов одинаковые, то все хосты этих проектов попадут в один отчёт) либо по ABC-сервису (в Wall-E ABC-сервис – это BOT-project-id). Возможна ситуация, когда в группу вошло много проектов, но сломанные хосты есть только в одном – Wall-E всё равно добавит всех владельцев всех проектов в наблюдатели для тикета и может выбрать ответственным человека, который не имеет отношения к проекту, в котором есть сломанные хосты – потому что он первый по алфавиту.

Выяснить, какие хосты попали в группу по bot-project-id можно, например, так:
```
$ wall-e projects get <id проекта, который указан в отчёте> | grep bot_project_id
$ wall-e projects list -C id, name,bot_porject_id | grep <$BOT_PROJECT_ID>
```

Вывести свой проект из этой группы можно одним из двух способов:
1. Сделать персональные настройки отчётов (см. описание [в документации](guide/reports.md) )
2. Изменить BOT-project-id в своём проекте. В перспективе это может иметь последствия, в какой-то момент Wall-E сходит в БОТ и изменит project-id для хостов в вашем проекте. Кроме того, однажды Wall-E начнёт авторизовывать хосты при добавлении и корректность настройки bot-project-id повлияет на этот процесс.

## Wall-E перевёл мой хост в статус invalid, как мне перевести его обратно в ready? {#faq-invalid}
Ситуаций, в которых хост переводится в `invalid`, в настоящий момент две:
1. [Хост переименовали через БОТ](#faq-rename)
2. У хоста сменился статус эксплуатации в OEBS (`DIAGNOSTICS`, `RESERVED`, `NOT_USED`)

Для возврата перименованного хоста необходимо выполнить операцию `fqdn-deinvalidation` (`wall-e hosts fqdn-deinvalidation <host_id>` в CLI или "FQDN deinvalidation" в действиях с хостом в UI). Хост при этом можно очистить (release), подтереть данные  старом имени в DNS и LUI (clear). Затем рекомендуется преднастроить и переналить хост.

Изменение статуса эксплуатации в OEBS Wall-E отслеживает самостоятельно. Хосты возвращаются в валидное состояние, когда статус в OEBS изменился на `OPERATION`, и при этом хост не был переименован. Переименованные же машины нужно возвращать самостоятельно, так как это действие может быть опасно для автоматического выполнения.

## Как мне переименовать хост? {#faq-rename}
В некоторых проектах сейчас есть необходимость переименовывать хосты, которые меняют какие-то параметры (назначение) внутри проекта, но при этом не покидают проект.

Wall-E сейчас не имеет поддержки такой операции, переименовать хост в нём нельзя, и на это есть причины:
* операция рискованная (многоступенчатая процедура, в которой обрыв на любом шаге приводит к неочевидным последствиям с возможной потерей хоста с радаров)
* операция не соответствует концепции HaaS, которая предполагает изоляцию бизнес-процессов от таких деталей, как имена хостов

Переименовать хост можно через БОТ, который описанными выше проблемами не озабочен. Wall-E **не** синхронизирует переименования из БОТ-а по описанным выше причинам плюс накладные расходы.

Для того, чтобы переименование прошло как можно более гладко и Wall-E подцепил новое имя хоста, можно придерживаться следующей процедуры:
* Проверить индивидуальные настройки хоста `wall-e hosts get $host`
* Переименовать хост в BOT-е.
* Проверить, что хост перешел в статус `invalid` в Wall-E (синхронизация проводится каждые 15 минут)
* [Выполнить операцию по деинвалидации хоста (FQDN deinvalidation)](#faq-invalid)
* Опционально можно преднастроить хост: `$ wall-e hosts profile -p <profile-name> -t <tag,tag> <inv|new-fqdn> --no-check`
* Переналить: `$ wall-e hosts redeploy --no-check <inv|new-fqdn>`

Информация о здоровье (нового) хоста появляется в системе мониторнига [примерно в течение трёх часов](#faq-expert-initial), поэтому после переналивки хост может перейти в статус `dead`, если не указать флаг `--no-check`.

Все операции в Wall-E (которые участвуют в этом процессе), могут быть [массовыми](cli.md#batch) или [групповыми](cli.md#groups). Чтобы не составлять два списка хостов (со старыми и новыми именами), имеет смысл в качестве идентификатора вместо fqdn использовать инвентарный номер хоста или его UUID в Wall-E.


## Не могу добавить/переналить IPv6-only машинку. Они вообще поддерживаются?

Для того, чтобы IPv6-only хост мог переналиться с помощью LUI, необходимо чтобы его конфигурация удовлетворяла требованиям, описанным [здесь](https://wiki.yandex-team.ru/users/okkk/howtousesetup6). Если говорить о поисковых машинках, то есть устное обещание от [osol@](https://staff.yandex-team.ru/osol), что все продуктивные машинки будут удовлетворять этим требованиям.

## Как задеплоить первичный секрет на хост, чтобы хост мог скачать остальные секреты из секретницы? {#faq-bootstrap}

Это можно сделать снаружи, для этого вам понадобится настроить активную сущность, которая будет каким-то образом понимать, что хост надо забутстрапить. Каким образом она будет это понимать – полностью на ваше усмотрение.

Мы рекомендуем использовать такой вариант, он yспешно используется в RTC: можно смотреть на специальную проверку [из схемы автоматики в Wall-E](automation/checks.md#automation-plot-checks). Для этого владельцу сервиса понадобится:
* завести свою схему автоматики, это можно сделать в пару кликов,
* создать специальную пассивную проверку, которая будет гореть, если хост требуется донастроить после наливки
* завести микросервис, который будет смотреть на эту проверку в Wall-E и бустрапить хост.

В общем-то, можно зажигать проверку и без Wall-E, а можно даже и без проверки: хост может стучаться в API вашего микросервиса и сигнализировать о том, что его надо донастроить, а микросервис может ходить на хост сам и донастраивать.

При этом важно, чтобы донастройка была недеструктивной: в API может прийти злоумышленник, который попросит донастроить сервер. Проверку в джагглере тоже может зажечь злоумышленник.

*Wall-E не умеет приносить секреты на хосты и в обозримом будущем не научится*. Причина в том, что в Wall-E отсутствуют транспорт и хранилище, которые нужны для того, чтобы безопасно донести секреты до хостов. Сертификаты, которые используются в RTC для авторизации хоста, не подходят для обращения в секретницу, см. [аргументацию СИБ](https://wiki.yandex-team.ru/passport/tvm2/Pochemu-ne-TLS-client-authentication/).

## У хоста отображается неправильная локация {#faq-outdated-location}
Информацию о расположении хоста Волли получает от RackTables. Если хост был выключен и перевезен в другое место, эта устаревшая информация о локации еще долго будет оставаться в RT. Для ее обновления достаточно включить хост.

## Где можно посмотреть на исходный код Wall-E? {#faq-sources}
[Backend](https://a.yandex-team.ru/arc/trunk/arcadia/infra/walle/server)
[Wall-e client](https://a.yandex-team.ru/arc/trunk/arcadia/infra/wall-e/client)
[Wall-e agent](https://a.yandex-team.ru/arc/trunk/arcadia/infra/wall-e/agent)
[Wall-e Juggler checks](https://a.yandex-team.ru/arc/trunk/arcadia/infra/wall-e/checks)
