# Аудитный лог

Все запросы, которые приходят в Wall-E через API (кроме GET-запросов и запросов, которые не прошли валидацию), а также все автоматические действия Wall-E над хостами, записываются в аудитный лог, по которому впоследствии можно понять, в результате каких действий (а зачастую главное - чьих) та или иная машина получила текущее состояние (перезагружена, переналита, мертва).

Аудитный лог можно посмотреть с помощью команды `wall-e audit-log get`. Вот несколько примеров строчек из аудитного лога:
```
2014.12.18 15:27:27 [konishchev@] [redeploy-host] [#100405679|man1-4612.search.yandex.net] -> 2014.12.19 12:43:57 [failed]: Host's MAC addresses are invalid or it fails to boot from PXE. Failed MAC addresses: f4:52:14:55:1e:60, 00:15:b2:a6:08:b4, 00:15:b2:a6:08:b5.
2014.12.24 13:08:43 [robot-automon@] [redeploy-host] [#900213327|sas1-1847.search.yandex.net] -> 2014.12.24 13:08:43 [accepted]
2014.12.24 11:34:04 [wall-e] [reboot-host] [#900195880|sas1-0017.search.yandex.net] -> 2014.12.24 11:48:34 [completed]
```

В каждой записи присутствует имя пользователя, который инициировал данное действие. Если в качестве имени пользователя указан `wall-e`, то это означает, что операцию инициировала автоматика Wall-E.

Формат записей в аудитном логе предельно прост. Разберем на примере:
1. Пользователь `konishchev@` в `2014.12.18 15:27:27` попросил переналить хост `man1-4612.search.yandex.net` (инвентарный номер `100405679`). Переналивка завершилась с ошибкой `Host's MAC addresses are invalid or it fails to boot from PXE. Failed MAC addresses: f4:52:14:55:1e:60, 00:15:b2:a6:08:b4, 00:15:b2:a6:08:b5.` в `2014.12.19 12:43:57`.
2. [Автоадмин](https://wiki.yandex-team.ru/users/sgjurano/automon) в `2014.12.24 13:08:43` попросил переналить хост `sas1-1847.search.yandex.net` (инвентарный номер `900213327`). Задача в процессе выполнения.
3. Автоматика Wall-E решила в `2014.12.24 11:34:04` ребутнуть хост `sas1-0017.search.yandex.net`. Операция успешно завершилась в `2014.12.24 11:48:34`.

Записи можно фильтровать по проекту, хосту, времени и другим параметрам. Подробности - `wall-e audit-log get --help`

Если указать опцию `-r/--show-reason`, то будет отображаться еще и причина, в результате которой было инициировано данное действие. Wall-E пишет причину для всех действий, которые он выполняет автоматически. Пользователь же может указать причину для каждого своего действия при помощи опции `-m/--reason`, тем самым оставив комментарий к своим действиям.

Опция `-d/--show-payload` включает отображение дополнительных данных в виде JSON-словаря, которые не отображаются по умолчанию. С помощью этих данных можно понять детали события, к примеру для события `redeploy-host` `payload` будет содержать конфиг наливки, который указал пользователь через API.

Жизненный путь API-запроса с точки зрения статусов в аудитном логе:
* Пришел запрос. Он заносится в аудитный лог со статусом `unknown`.
* Проверяются различные условия. Если запрос отвергается (к примеру, попытка ребутнуть хост, который уже переналивается), то запись в логе получает статус `rejected` + текст ошибки. Если запрос поступает в обработку, то - `accepted`.
* Если кто-то инициирует отмену операции, запрос получает статус `cancelled`.
* Если операция завершается с ошибкой, то она получает статус `failed` + текст ошибки.
* Если операция завершается успешно, то она получает статус `completed`.
