# Авторизация

## Администраторы Wall-e
Первая группа пользователей - это "Администраторы" Wall-E, в которую входят разработчики Wall-E. Данная группа обладает правами на:
- выключение глобальной автоматики починки серверов;
- выключение автоматики по кастомному селектору (ДЦ, очередь, модуль и т.д.) в случае крупных аварий, чтобы минимизировать blust-radius;
- выключение проектной автоматики (с обязательным уведомлением владельцев проекта), дабы исключить влияние одного потребителя на других;

Также, Администратор может выполнить какие-либо действия над хостом, не принадлежащим к проектам, которыми он владеет, только в том случае, если при выполнении команды он укажет параметр `--sudo`, например: `wall-e hosts reboot --sudo $host`.

## Проекты Wall-E
Разграничение прав остальных пользователей (помимо Администраторов) в Wall-E ведется на уровне [проектов](projects.md). Wall-e проект - это контейнер, содержащий в себе множество железных машин. Создать проект может любой сотрудник Яндекса, но модифицировать - любой его владелец, а также любой его администратор. При создании проекта происходит проверка, что пользователь состоит в ABC-сервисе, указанном в форме создания проекта.

Подробнее о том, что такое проект можно почитать [здесь](projects.md).

## Роли Wall-E
Роли в проекте выдаются через IDM или через UI/CLI Wall-E (но согласование происходит через IDM).
Т. к. на данный момент в нашей компании нет единого места, в котором хранилась бы информация о владельцах машин, то в Wall-E используется следующая схема авторизации:
### 1. Владелец проекта (owner) в Wall-E
Владелец проекта имеет права: 
- осуществлять все доступные в Wall-E операции с проектом и хостами в проекте;
- управлять ролями в проекте, т.е. может добавлять/удалять других валедельцев, администраторов и т.д.
- добавлять хосты в проект, если они не присутствуют ни в одном другом проекте.

В качестве владельцев проекта могут выступать как конкретные люди, так и вики-группы или департаменты, в этом случае любой сотрудник департамента или член группы будет иметь права на модификацию проекта, то есть будет считаться владельцем.

Список владельцев проекта можно поменять в UI или командами `wall-e projects owners {add,set,remove} $project $owners`, где `$owners` – это список людей или групп через запятую. Люди и роботы добавляются в список владельцев по логину, логин указывается без всяких спецсимволов, например: `robot-walle,n-malakhov`. Группы добавляются в список по атрибуту "URL группы" с префиксом "@", например `@robots,@yandex_search`. Список wiki-групп есть [здесь](https://staff.yandex-team.ru/groups/), список всех подразделений Яндекса можно посмотреть [здесь](https://staff.yandex-team.ru/departments/). Посмотреть, в какие вики-группы и департаменты входит человек, можно одним запросом через API Стаффа, например [так](https://staff-api.yandex-team.ru/v3/person?_pretty=1&_one=1&_fields=groups.group.url,department_group.ancestors.url,department_group.url&login=robot-walle) (нужно поменять логин сотрудника в параметрах запроса). Запросить участие в группе можно через [IDM](https://idm.yandex-team.ru/system/staff#main=roles,rf=1,f-system=staff,f-status=active,sort-by=-updated,rf-scope=staff/groups).

Если необходимо получить доступ к существующему проекту, то нужно обратиться к одному из его владельцев. Список владельцев можно посмотреть в UI или командой `wall-e projects owners get $project`.

Как уже было сказано выше, на данный момент нет возможности проверить, действительно ли человек имеет права на работу с конкретным хостом, поэтому данная схема авторизации является компромиссом с текущими реалиями и вероятно будет пересмотрена в будущем. Она полностью исключает случайное выполнение действий над чужими хостами и предоставляет минимальную защиту от злого умысла: да, человек может добавить в свой проект чужие хосты, если они еще не присутствуют в Wall-E, но сделать это может не любой человек, а только тот, кто является владельцем хотя бы одного проекта.

### 2. Noc_access, user и superuser
Помимо роли **owner**, обозначающей владельца проекта и обладающей всеми правами, существует еще три роли: 
- **noc_access** - дает права на доступ на хосты по SSH и беспарольный sudo или `cap_net_raw,cap_net_admin` на:
* /usr/sbin/tcpdump
* /sbin/ip
* /sbin/ethtool
* /bin/ping
* /bin/ping6
* /bin/netstat
* /usr/sbin/ya-hbf-*

- **user** -  дает права на осуществление любых операций в Wall-E над хостами проекта, а также связанные права в CAuth на доступ по ssh на хосты и парольный sudo;
- **superuser** - то же, что user, но дополнительно права в CAuth на беспарольный sudo;

### 3. Роли в связанных системах
Роли, которые выданы на проекты в Wall-E, дополнительно дают права в связанных системах:
- CAuth: получает из Wall-E списки хостов, проектов и ролей в них, выдает соответствующие права (см. выше);
- IPMI-proxy: получает список owners и сохраняет у себя для последующей авторизации - [подробнее](https://wiki.yandex-team.ru/dca/services/ipmiproxy/auth/#wall-e)

## Связь wall-e и ABC {#walle-abc}

### Связь ресурса в bot и сервиса в ABC
Каждый ресурс, в том числе железная машина, имеет инвентарный номер, по которому его можно найти в системе учёта оборудования [bot](http://bot.yandex-team.ru/).
Там же, в bot, каждый ресурс имеет атрибут, указывающий на ABC сервис. С помощью этого атрибута можно определить сервис ABC, которому выделен тот или иной ресурс, вести учет ресурсов по сервисам и так далее.

### Связь wall-e проекта и сервиса в ABC
Wall-e контролирует процесс добавления ресурсов в проект. Он проверяет соответствие ABC-сервиса вводимого ресурса и ABC-сервиса указанного в Wall-e проекте. Это позволяет избежать ситуации, когда пользователи добавляют чужие ресурсы в свой wall-e проект.
Поэтому важно выбрать тот ABC проект, к которому привязано ваше железо.

Примечание: Подобное поведение включено только для проектов, [созданных пользователями самостоятельно](https://clubs.at.yandex-team.ru/wall-e/47). В проектах, созданных до появления возможности создавать такие проекты самостоятельно, такие ограничения пока не применяются.
