# Настройки CAuth
Wall-E является одним из источников информации о хостах, проектах и пользователях для системы централизованной аутентификации и авторизации (CAuth). 

Соответственно, если для доступа на сервера определенного сервиса используется CAuth, то через настройки проекта в Wall-E с этими хостами можно задать определенные опции в CAuth, которые в свою очередь CAuth (серверная часть) получит из Wall-E в ходе периодической синхронизации (помимо списка проектов, хостов и ответственных):

1. Flow type - отвечает за то, откуда Cauth будет брать информации об "источниках" прав - со стороны локального агента cauth на хосте или из настроек, заданных в "доверенных" системах (напр., Wall-E или YP). Может принимать следующие значения:
   - classic - дефолтное поведение, когда локальный агент cauth-agent на хосте считывает данные из локального файла с конфигурацией и при обращении в CAuth (серверную часть) передает, каким "источникам" прав для этого хоста доверять (напр., дай мне права из source = Wall-E, IDM - Conductor)
   - backend_sources - новое поведение, когда CAuth (серверная часть) получает знание об "источниках" прав для хоста или группы хостов из "доверенных" систем (напр, Wall-E или YP). Сами "источники" задаются параметром Trusted sources в этом же блоке настроек

2. Trusted sources - список "доверенных источников" прав для flow type = "backend_sources" (для classic-схемы эта настройка игнорируется).
   - Bot - права выдаются "Менеджерам аппаратных ресурсов" и "Руководителю сервиса" в ABC-сервисе, к которому привязан хост
   - Conductor - права выдаются администраторам проекта Conductor и ответственным за группы в Conductor
   - Hd - используется только для машин-зомбиков. Права выдаются Ответственным за роботов и Руководителю ABC-сервиса, к которому привязан зомбик
   - Idm - все права, выданные через IDM
   - IdmCms (= IDM - CMS) - права, выданные через IDM на любой объект, кроме прав на генерильные группы
   - IdmConductor (= IDM - Conductor) - права, выданные через IDM на любой объект, кроме прав на кондукторные группы
   - Walle - права выдаются в соответствии с [ролевой моделью Wall-E](https://docs.yandex-team.ru/wall-e/guide/authorization)
   - YP - права на контейнеры, которые передает YP
   - YCloud - legacy, поддерживается до перехода Облака на oslogin
   - CMS - legacy, поддерживается для интеграции с GenCfg CMS

3. Sources for keys - источник пользовательских ssh-ключей:
   - staff - классический метод, когда CAuth получает и раскладывает пользовательские ключи со staff
   - secure - Cauth получает secure-ключи из Skotty
   - insecure - Cauth получает insecure-ключи из Skotty

4. Insecure CA list URL, Secure CA list URL, Sudo CA list URL, KRL URL - поля, определяющие адреса CA для разного типа доступов. Для работы со Skotty должны быть заполнены следующими значениями:
   - Insecure CA list URL - https://cauth.yandex.net:4443/keylists/main/insecure
   - KRL URL - https://cauth.yandex.net:4443/keylists/main/all.zst
   - Secure CA list URL - https://cauth.yandex.net:4443/keylists/main/secure
   - Sudo CA list URL - https://cauth.yandex.net:4443/keylists/main/sudo

Если на хостах не используется cauth-agent - оставьте настройки пустыми.
