# Состояние хостов

## Стейты и Статусы хостов {#host-statuses}

У каждой машины в Wall-E есть два поля: `state` и `status`, которые описывают текущее ее состояние.

`state` определяет текущее состояние машины с точки зрения эксплуатации:
* `free` - пустая машина, которая еще не отдана в эксплуатацию. Как правило: не имеет записей в DNS, не налита (или налита каким-нибудь мусором), переключена в 999 VLAN.
* `probation` - машина, находящаяся в процессе подготовки к эксплуатации. Хосты в этом состоянии автоматически попадают в `assigned`, когда все этапы подготовки будут пройдены, и все проверки зеленые. Хост в `probation` будет задаунтаймлен Wall-e до тех пор, пока либо не перейдет в `assigned`, либо в `dead`/`invalid`.
* `assigned` - налитая машина, которая находится в эксплуатации.
* `maintenance` - машина находится на обслуживании. Более подробно об этом состоянии можно прочитать [здесь](maintenance.md).

`status` определяет текущее состояние машины:
* `ready` - машина готова к работе.
* `manual` - в этот статус машина переводится вручную администратором, чтобы пометить ее как "в данный момент эта машина находится под моим личным контролем".
* `rebooting` - производится [перезагрузка](hosts.md#host-rebooting) машины.
* `profiling` - производится [преднастройка](hosts.md#host-profiling) машины.
* `deploying` - производится [переналивка](hosts.md#host-deploying) машины.
* `deactivating` - служебный статус, который возможно исчезнет в будущем. Переводит машину в состояние `dead`. Применяется в случае если автоматика считает машину мертвой.
* `dead` - машина считается мертвой.
* `invalid` - если в процессе работы Wall-E замечает, что какой-то хост пропал из Бота или иего переименовали без ведома Wall-E, то хост переводится в состояние `invalid`. В случае переименования владелец хоста должны выполнить команду `wall-e hosts fqdn-deinvalidation <host_id>`. Никакого автоматического переименования в базе Wall-E на данный момент не делается из соображений безопасности. Предполагается, что администраторы будут следить за появлением таких хостов и приводить базу Wall-E в актуальное состояние.

Произвести какое-либо действие (перезагрузить/переналить) можно только над машиной, находящейся в статусах `ready`, `manual` или `dead`. При попытке, к примеру, переналить машину, которая уже переналивается в данный момент, Wall-E выдаст ошибку `The host has an invalid state for this operation`. Этого можно избежать, [отменив текущую операцию](hosts.md#host-force-status).

## Статусы и Автоматика

При выполнении команд на prepare/profile/reboot/redeploy операция считается выполненной только в том случае, если все проверки переходят в нормальное состояние (`passed`). В противном случае машина переводится в статус `dead`, и операция считается завершившейся с ошибкой. Это поведение можно изменить, отдавая команду на reboot/redeploy с опцией `--no-check` - в этом случае команда будет выполнена без последующей проверки состояния хоста, и хост будет переведен в состояние ready (это не отменяет последующие проверки его состояния и автоматическое лечение - см. ниже).

Если хост получил статус `dead` в результате действий пользователя, то даже если впоследствии проверки перейдут в нормальное состояние, он не получит статус `ready` автоматически, и для него не будет срабатывать какая-либо автоматика по устранению неполадок, пока администратор вручную не [переведет его в статус ready](hosts.md#host-force-status). Если хост получил статус `dead` в результате действий автоматики, то хост может быть переведён снова в статус `ready`, если все его проверки перейдут в состояние "OK" и все правила обработки проверок будут считать, что хост здоров. Это может привести к циклам, когда хост переходит в dead каждые несколько дней, такие хосты попадают в [отчёты](reports.md), которые Wall-E создаёт для всех проектов.

Статус `dead` является стадией, требующей внимания человека. Предполагается, что администратор на регулярной основе будет просматривать список хостов, находящихся в статусе `dead`, оценивать причину, по которой автоматика не справилась с данной проблемой, устранять эту проблему и [переводить хост в статус ready](hosts.md#host-force-status), чтобы Wall-E снова начал мониторить его состояние и производить автоматическое лечение.

При выявлении ошибок, которые случаются довольно часто, но с которыми автоматика не может справиться в данный момент, смело сообщайтесь к разработчикам Wall-E: наша задача как раз состоит в том, чтобы покрыть автоматикой максимальное количество проблем и, насколько это возможно, минимизировать ручную работу администраторов.


## Operation state {#operation-state} {#operation_state}

У каждой машины в Wall-e есть поле `Operation state`, которое обозначает, что нода является работоспособной (с точки зрения `SLO по availability`):
* `operation` - хост работоспособен;
* `decommissioned` - хост забрали для выполнения регламентых работ (NOC, ITDC, админы);

На текущий момент, поле не влияет ни на какие процессы внутри Wall-e, а просто показывает количество работоспособных хостов в кластере.
