# Работа с хостами

Все команды, оперирующие множеством хостов, могут принимать в качестве аргументов список хостов. Если в аргументах команды не указано ни одного хоста, их список будет взят с stdin. При указании опции `--syntax blinov` список хостов будет пропущен через [Калькулятор Блинова](https://doc.yandex-team.ru/generated/skynet/sky/blinovcalc.html) (используется старая версия калькулятора по состоянию на середину 2014 года).

Если вы назначили какую-нибудь продолжительную операцию на хост (ребут, преднастройка, наливка), и она завершилась с ошибкой, то саму ошибку можно посмотреть в [аудитном логе](audit_log.md). Логи наливки можно посмотреть через `wall-e hosts deploy-log $host`.

Операции, которые можно запустить для хоста, дополнительно настраиваются флагами:
* "**Проверить после выполнения**" (в UI) или `--no-check` в консольном клиенте. По умолчанию Wall-E дожидается, когда от Эксперта начнёт приходить новый мониторинг после операции. Если хост не ожил, то Wall-E либо пытается автоматически вылечить хост, либо переводит его в `dead`, если операция была ручная или больше ничего сделать нельзя. Если снять галочку в интерфейсе или указать флаг `--no-check` в консольном клиенте, то Wall-E не ждёт мониторингов, а сразу считает, что операция прошла успешно, соответственно, хост не перейдёт в `dead` в результате такой операции.

* "**Автопочинка**" (в UI) или `--with-auto-healing` в консольном клиенте включает реакцию на мониторниг для ручных операций. По умолчанию, если операция была ручная, и мониторинг после операции плохой, то wall-e просто переводит хост в `dead`. Этот флаг разрешает действовать так же, как будто операция была автоматическая: пытаться вылечить хост, если он не ожил в процессе операции.

* "**Не создавать заявки в ДЦ**" (в UI) или `--no-admin-requests` в консольном клиенте. По умолчанию, если в процессе операции обнаружится проблема, которая блокирует операцию (на текущий момент это проблемы с IPMI), Wall-E создаёт формализованную заявку через БОТ. Если поставить эту галочку в UI или задать флаг `--no-admin-requests` в консольном клиенте, то Wall-E не будет не создавать формализованную заявку в БОТ а сразу переведет хост в `dead`.

* "**Игнорировать CMS**" (в UI) или `--ignore-cms` в консольном клиенте. Если хост действительно мёртвый, а CMS его не отдаёт по каким-то своим причинам (например, пытается унести с него инстансы сервиса, но не может, потому что хост мёртвый), то эта опция позволяет вылечить хост без запроса к CMS. При этом Wall-E на самом деле *не спрашивает разрешения у CMS*, то есть, CMS вообще не узнает, что с хостом производится какая-то операция.

В процессе обработки продолжительных операций у хоста меняется поле `host["task"]["status"]`, которое отражает этап, выполняемый в данный момент над хостом. Некоторые этапы также меняют поле `host["task"]["status_message"]`, помещая в него некоторую разъясняющую информацию о текущем прогрессе в выполнении этапа, а если в процессе обработки операции происходит какая-либо ошибка, она сохраняется в `host["task"]["error"]`. Все это можно можно посмотреть либо в информации о хосте:
```
$ wall-e hosts get $host
host:
  [...]
  task:
    error: 'Failed to add sas1-2866.search.yandex.net -> 2a02:06b8:b010:0070:0225:90ff:fe83:1afc
      AAAA record: DNS API returned an error: Server returned 400 Bad request'
    owner: wall-e
    status: setup-dns:preparing-dns-request
```

либо вывести в виде дополнительных колонок в команде просмотра хостов:
```
$ wall-e hosts list-only -C name,status,task_status,task_status_message,task_error < hosts
            FQDN                Status    Task status           Task status message           Task error

sas1-3026.search.yandex.net       ready        -        -                                     -
sas1-2866.search.yandex.net   preparing     monitor     Waiting when the host become alive.   -

> Listed 2 hosts. Total: 2.
```

## Добавление хоста {#host-adding}

Чтобы с хостом можно было работать, его нужно добавить в базу Wall-E. Хосты добавляются только в [проект](projects.md), существование хоста без проекта невозможно:
`$ wall-e hosts add $project $host`

Если при выполнении команды не указать дополнительные опции, то:
* [Ограничения](restrictions.md) для хоста [будут взяты из проекта](restrictions.md#default-restrictions).
* При [переналивке](#host-deploying) хоста будут использоваться дефолтная наливайка и конфиг наливки, указанные в проекте.
* [Статус хоста](host_statuses.md) будет выставлен в `assigned:ready`.

Все эти параметры можно задать при добавлении хоста, к примеру, за хостом можно закрепить наливайку и конфиг наливки, отличные от тех, что используются в проекте, если при добавлении указать опции `--provisioner` и `--config`.

`$ wall-e hosts add $project $host --provisioner lui --config web`

### Дополнительные действия
Если в проект добавлять рабочий, налитый хост (в состоянии `ASSIGNED`), то Wall-E сразу выполнит несколько полезных действий:
* Прописывает в BOT-е проект, указанный в настройках проекта Wall-E
* Прописывает хост в DNS. Для этого в проекте должны быть настроены dns domain и [vlan-схема](../automation/vlans.md#vlan-scheme) и хост должен добавляться с опцией `--dns`.
* Переключает хост в проектные VLAN-ы. Для этого в проекте должна быть настроена [vlan-схема](../automation/vlans.md#vlan-scheme).
* Прописывает хост в CMS проекта, если CMS поддерживает CMS API v1.1 и выше. Отключается флагом `--ignore-cms`.
* Прописывает сервер в LUI с правильным конфигом наливки, если для наливки хоста используется LUI.


Эта операция производится с уведомлением CMS проекта. В CMS отправляется задача с полем `action: "prepare"`. После того, как Wall-E удаляет эту задачу из CMS, хост доступен и готов к работе. CMS проекта может запретить эту операцию, переведя задачу в статус `rejected`. CMS не уведомляется, если владелец проекта при добавлении хоста указал флаг `--ignore-cms` или `--instant`.

{% note warning %}

Настоятельно рекомендуется включить во все свои наливки установку [Wall-E.Agent](../agent.md). Wall-E будет работать с вашими машинами и без него, но некоторый функционал будет недоступен, либо часть функционала будет работать не на должном уровне. Подробности можно почитать - [тут](../agent.md#agent-installation-reasons).

{% endnote %}


## Просмотр

Просмотр хостов осуществляется командами `wall-e hosts list` и `wall-e hosts list-only`. Обе команды полностью идентичны за исключением того, что `hosts list` ищет хосты среди всего множества хостов, зарегистрированных в Wall-E, а `list-only` - только те, которые вы укажете через опции командной строки или stdin.

Показать все хосты, зарегистрированные в Wall-E:
`$ wall-e hosts list`
По умолчанию выводятся только первые 100 хостов. С помощью опции `-L` можно указать максимальное количество выводимых хостов.

Показать все указанные хосты, если они есть в Wall-E:
```
$ wall-e hosts list-only host1 host2
$ wall-e hosts list-only < hosts-list
```
Данная команда, в отличие от предыдущей по умолчанию отображает все указанные хосты, хотя также поддерживает опцию `-L`.

К примеру, вывод команды `wall-e hosts list -L 2` будет примерно следующим:
```
  #              FQDN            State     Status   Task status          Config

100014   imgs30-108.yandex.ru   assigned    ready        -         web-ubuntu-12.04-dev
100017   imgs30-106.yandex.ru   assigned    ready        -        @web-ubuntu-12.04-dev

> Listed 2 hosts. Total: 16162.
```

Символ `@` в имени конфига наливки или имени наливайки означает, что хост имеет собственную конфигурацию наливки, и при переналивке будет использоваться она, а не та, которая указана в проекте.

По умолчанию выводится далеко не вся информация: список отображаемых колонок задается с помощью опции `-C`. Также хосты можно фильтровать по различным полям.

К примеру, вот так можно посмотреть все хосты с [неполадками](../automation/general.md) из проекта `search`:
```
$ wall-e hosts list --project search --health failure -C name,health -L 2
       FQDN                            Health

ws28-167.yandex.ru                      disk
ws26-360.yandex.ru   meta-missing,disk-missing,unispace-missing

> Listed 2 hosts. Total: 198.
```


## Просмотр всей имеющейся информации о хосте {#host-get}

Команда `wall-e hosts list` удобна для просмотра информации о нескольких хостах одновременно, но для просмотра информации только по одному хосту гораздо удобнее использовать команду `wall-e hosts get $host`: она отображает всю информацию, которая содержится об указанном хосте в базе Wall-E.

У данной команды также есть опциональные ключи, которые включают отображение дополнительной информации, которая собирается во время выполнения команды из других сервисов. К примеру, с помощью ключа `--expert-status` можно посмотреть текущий статус хоста в Экспертной системе, с помощью `--expert-events` -  лог последних событий для хоста из Эксперта, а опция `-c` добавляет в вывод объект `configuration`, который содержит максимально актуальную информацию о текущей конфигурации хоста: MAC-адреса, switch/port, спущенные VLAN'ы (информация собирается во время обработки запроса, поэтому команда может выполняться в течение нескольких секунд).

## Включение (power on) {#host-powering-on}

Включение хоста производится командой `wall-e hosts power-on $host`
Если в данный момент у хоста есть проблемы с работой IPMI, Wall-E автоматически [заводит заявку в Бот](../automation/admin_requests.md).


## Выключение (power off) {#host-powering-off}
Выключение хоста производится командой `wall-e hosts power-off $host`

При этом будут выполнены следующие команды ipmitool:
* `power soft`
* `power off`, если `power soft` не выключил машину

Если в данный момент у хоста есть проблемы с работой IPMI, Wall-E автоматически [заводит заявку в Бот](../automation/admin_requests.md).

При успешном завершении операции хост будет переведен в [maintenance state](maintenance.md).

## Перезагрузка {#host-rebooting}

Хост можно ребутнуть:
`$ wall-e hosts reboot $host`

При этом будут выполнены следующие команды через IPMI-Proxy:
* `power soft`
* `power off`, если `power soft` не выключил машину
* `power on`

`power reset` не используется, т. к. нет возможности определить, выполнилась ли эта команда или нет (IPMI-Proxy может вернуть OK, но при этом не ребутнуть хост).

Если в данный момент у хоста есть проблемы с работой IPMI, Wall-E автоматически [заводит заявку в Бот](../automation/admin_requests.md).

Для перезагрузки хоста также можно использовать доступ по ssh – для этого нужно разложить на сервера публичный ключ пользователя [robot-walle@](http://staff.yandex-team.ru/robot-walle), который выложен на staff. Подробнее о том, как выполняется ребут сервера, можно [почитать здесь](../dev/stages/reboot.md).


## Преднастройка {#host-profiling}

Wall-E позволяет отправлять машины в преднастройку через [Eine](http://eine.yandex-team.ru/):

`$ wall-e hosts profile -p $profile --profile-tags $tag1,$tag2 $host`

Т. к. Eine не умеет должным образом обрабатывать проблемы с IPMI, Wall-E сначала ребутает хост, чтобы проверить работоспособность IPMI, и только потом отправляет его в преднастройку. Если выясняется, что IPMI в данный момент не работает, то Wall-E автоматически [заводит заявку в Бот](../automation/admin_requests.md).

Если для проекта задана [VLAN-схема](../automation/vlans.md#vlan-scheme), то перед преднастройкой хост будет переключен в общий 999 VLAN, чтобы исключить проблемы с правами доступа на стороне Eine, а после завершения преднастройки - в [VLAN'ы, заданные для этого хоста](../automation/vlans.md#automatic-vlan-switching).

По-умолчанию используется профиль **Flexy**.

### Графический пользовательский интерфейс

В UI Wall-E представлены к выбору уже готовые конфигурации преднастройки. Ниже дано их описание и соответствие [тегам Eine](https://wiki.yandex-team.ru/dc/flexy).

Имя                     | Теги
----------------------- | -----------------------
default                 | `full_profiling`
firmware-update         | `memory-relax + smart-relax + firmware_update`
highload-test           | `full_profiling + advanced_load`
extra-highload-test     | `full_profiling + advanced_load + extra_load`
disk-rw-test            | `full_profiling + dangerous_load`
dangerous-highload-test | `full_profiling + advanced_load + extra_load + dangerous_load`
swp-up                  | `swp_up`

## {#default-profile-configuration}
Для каждого проекта можно задать профиль преднастройки по умолчанию:
`$ wall-e projects profiling set $project --profile $profile --profile-tags $tag1,$tag2`

Это позволит не указывать его каждый раз при использовании команд [prepare](#host-preparing)/[profile](#host-profiling), а также позволит Wall-E использовать преднастройку как еще один способ лечения машин.

{% note tip %}

Если ваш сервис не способен переживать автоматическую переналивку машин, то вдобавок к [ограничению](restrictions.md) `automated-redeploy` имеет смысл также задать тег `smart-relax` в профиле преднастройки по умолчанию. Это существенно снизит вероятность того, что во время преднастройки инженеры поменяют диск на машине (который может быть незарезервирован RAID'ом). Явно мы это, к сожалению, запретить не можем через существующий интерфейс EaaS, но добавление `smart-relax` существенно снижает такую вероятность: данный тэг выключает проверку текущего состояния дисков (S.M.A.R.T.), и в таком случае их могут заменить только в том случае, если диски настолько разломаны, что машина не может пройти с ними преднастройку в принципе.

{% endnote %}

Если нужно отправить хост в преднастройку с деструктивным профилем (тег `disk-dangerous` тоже деструктивен), то имеет смысл сразу запланировать переналивку хоста. Чтобы хост налился с имеющимися настройками, достаточно указать опцию `--redeploy`, если нужно налить с другим конфигом, то можно указать опцию `--config={config-name}`. Во втором случае указанный конфиг наливки будет сохранён в настройках хоста и станет его дефолтным конфигом (см. [переналивка](#host-deploying)).

Если нужно проигнорировать различные проверки, которые происходят в EINE на этапе discovery (проверка комплектаций, ошибок в дисках, памяти, sel логах, подключение дисковых полок, и т.д.), то можно использовать тег `check=none`

{% note warning %}

Если отправить хост преднастраиваться с тегом `disk-dangerous`, то wall-e сам запланирует переналивку, как если бы была указана опция `-r`.

{% endnote %}

`$ wall-e hosts profile -r $host`
`$ wall-e hosts profile --profile $profile --profile-tags $tag1,$tag2 --provisioner $provisioner --config $config --deploy-tags $d-tag1,$d-tag2 $host`


## Переналивка {#host-deploying}

**Переналивка c дефолтным конфигом** (конфигом проекта либо [собственным конфигом хоста](projects.md#deploy-config)):
`$ wall-e hosts redeploy $host`
При этом:
* Если для хоста заданы наливайка и конфиг, то используются параметры хоста (наливайка, конфиг, теги).
* Если для хоста не заданы теги, то они **не подтягиваются** из проекта. Нальётся без тегов.
* Если для хоста не заданы параметры, то используются параметры из проекта (в этом случае будут использованы теги, заданные в проекте).

Обеспечение работы автоматики Wall-E достигается доставкой сообщений о здоровье хоста, поэтому на хосте должен быть установлен пакет [клиента Juggler](https://docs.yandex-team.ru/juggler/client/basics) (например, `config-juggler-search`), в [конфиге клиента](https://docs.yandex-team.ru/juggler/client/configs) в секции \[client\] в поле `check_bundles` должен быть указан [бандл с проверками Wall-E](../checks_bundle.md) (`check_bundles=...,wall-e-checks-bundle,...`), также должен быть установлен пакет `yandex-hw-watcher`. Убедитесь, что клиент с бандлом и hw-watcher будут установлены в процессе наливики или после нее.

**Переналивка с кастомными параметрами** (также изменит текущий конфиг хоста в Wall-E). Не рекомендуетс к использованию, воспользуйтесь встроенной подсказкой в cli при необходимости.

При этом:
* Если не указать наливайку, то используется та, которая задана в настройках хоста либо в параметрах проекта.
* Если не указать теги, они **не подтягиваются** из параметров хоста или проекта. Нальётся без тегов.
* Параметры, с которыми будет наливаться хост, сохранятся в настройках хоста.

Если для проекта задана [VLAN-схема](../automation/vlans.md#vlan-scheme), то после завершения наливки с помощью Eine или перед наливкой с помощью LUI хост будет [автоматически переключен в нужные VLAN'ы](../automation/vlans.md#automatic-vlan-switching).

**Network** - параметр настройки наливки (на уровне проекта или хоста), возможен выбор между опциями "Project" и "Service".
* "Project" - наливка производится через проектный VLAN ([требования к настройке проектной сети](https://wiki.yandex-team.ru/haas/services/setup/network/))
* "Service" - наливка производится через сервисный VLAN в Setup (возможен также вызов через CLI `$ wall-e hosts redeploy $host --deploy-network service`). При использовании этой опции следует учесть, что в процессе наливки хост получает адрес из другой сети, а после возвращения в свою сеть IP-адрес хоста сменится.

При этом в настройки хоста сохранится конфиг наливки и выбранная сеть, в следующий раз хост можно будет переналивать без указания дополнительных параметров. Подробнее о том, что это такое, [в анонсе](https://clubs.at.yandex-team.ru/sysadmin/12589).

## Конфиг наливки {#deploy-config}
Конфиг наливки задаётся одним из перечисленных способов:
* При создании проекта задаются параметры наливки по умолчанию
* Параметры наливки по умолчанию в проекте можно изменить командой
  `$ wall-e projects provisioner set $project -p $provisioner -c $config [-t $tag1,$tag2]`

Для хоста можно переопределить конфиг наливки. Делать это не рекомендуется.
* При [добавлении](#host-adding) хоста в базу Wall-E можно указать кастомные параметры наливки
* Изменить кастомные параметры наливки хоста можно командой deploy-config, воспользуйтесь встроенной подсказкой в cli при необходимости
* При [переналивке](#host-deploying) хоста с кастомными параметрами новые параметры наливки сохраняются в БД. Удалить можно командой
  `$ wall-e hosts deploy-config remove $host`

При задании кастомных параметров наливки:
* Если в качестве наливайки используется LUI, то Wall-E также внесет изменения в ее базу данных, если данный хост в ней присутствует.
* Если не указать наливайку, то будет запомнена та, которая задана в настройках хоста либо в параметрах проекта.
* Если не указать теги, то будет запомнена настройка "без тегов".


## Работа с VLAN

Wall-E может управлять VLAN-ами для проекта, если в проекте есть соответствующие настройки. Более того, переключать VLAN-ы вручную, если это необходимо, тоже рекомендуется через Wall-E. Wall-E проверяет доступ проекта к VLAN-ам, автоматизирует процесс переключения, а для ручных операций предоставляет интерфейс с авторизацией и проверками доступа.

[Подробности описаны в специальной секции документации.](../automation/vlans.md)

Переключить VLAN-ы для сервера можно командой
`$ wall-e hosts switch-vlans -m 'reason for the action' [--network-target project|service|parking]`

Для хоста можно задать персональные дополнительные VLAN-ы. Это делать не рекомендуется. Воспользуйтесь встроенными подсказками cli при необходимости.

## Первичная настройка {#host-preparing}

Если хост еще не введен в эксплуатацию, то единственное, что он имеет - это инвентарный номер, и для того, чтобы привести его в рабочее состояние, необходимо:
* Сгенерировать имя в соответствии с [политикой именования хостов](../automation/dns.md#dns-algorithm-names) в проекте и поставить это имя в соответствие хосту в BOT (если не указан флаг keep hostname)
* Прописать правильный OEBS-проект в BOT-е
* Выполнить [преднастройку](#host-profiling) (опционально)
* [Переключить в нужные VLAN'ы](../automation/vlans.md#automatic-vlan-switching)
* Выделить IP-адреса
* [Налить](#host-deploying) с нужным конфигом
* [Прописать хост в DNS](../automation/dns.md)
* Уведомить [CMS](../cms/general.md) проекта о появлении нового хоста

{% note info %}

Для того, чтобы в проекте можно было использовать первичную настройку, его нужно настроить определённым образом. По вопросам поддержки вашего проекта и со всеми вопросами можно [обращаться к нам](general.md#contacts).


Вся процедура первичной настройки завязана на:
* [L3-схему](https://wiki.yandex-team.ru/noc/l3-dc-user-guide) конфигурации сети (тем не менее, есть поддержка l2-сегмента без IPv4).
* Специфику определения VLAN'ов, в которые необходимо переключить машину.
* Отказ от использования [selfdns.sh](https://wiki.yandex-team.ru/infrasearch/common/selfdns.sh) в пользу [автоматической починки DNS-записей силами Wall-E](../automation/dns.md#dns-fixing).

{% endnote %}


Первоначальная настройка хостов производится следующим образом:

Хосты добавляются в проект со `state=free`:
`$ wall-e hosts add $project --state free < hosts`

Затем для них выполняется команда `prepare`:
`$ wall-e hosts prepare --profile $profile --config $config < hosts`, где:
* `$profile` - профиль, которым машина будет [преднастроена](#host-profiling) (если машина уже была преднастроена, то можно вместо `--profile` указать `--skip-profile`, чтобы пропустить этап преднастройки).
* `$config` - конфиг, с которым машина будет [налита](#host-deploying).

После успешного выполнения операции `prepare` хосты будут переведены в `state=assigned` и будут считаться полностью готовыми к эксплуатации.

Эта операция производится с уведомлением CMS проекта. В CMS отправляется задача с полем `action: "prepare"`. После того, как Wall-E удаляет эту задачу из CMS, хост доступен и готов к работе. CMS проекта может запретить эту операцию, переведя задачу в статус `rejected`.


## Изменение статуса и отмена текущей операции {#host-force-status}

Текущее состояние хоста (`state`) можно поменять следующими командами (более подробно о состояниях хостов см. [Статусы машин в Wall-E](host_statuses.md)):
* `$ wall-e hosts set-assigned $host`
* `$ wall-e hosts set-maintenance $host`

Отменить выполняемую в данный момент операцию [перезагрузки](#host-rebooting)/[преднастройки](#host-profiling)/[переналивки](#host-deploying) машины можно с помощью команды `$ wall-e hosts cancel-task $host`. Статус при этом изменится на дефолтный статус `ready`.

Важно иметь в виду, что в данном случае операция будет отменена мгновенно (не асинхронно) и только на стороне Wall-E без каких-либо попыток отменить активную наливку/преднастройку в LUI/Eine. Поэтому нужно отдавать себе отчет, что хост скорее всего останется в неопределенном/полуразломанном состоянии.

Wall-E оставляет за собой право при отмене операции сделать попытку отменить ее в Eine/LUI, но в силу того, что команда `force-status` должна всегда гарантированно выполняться за небольшое время, Wall-E не будет делать каких-либо повторных попыток, если Eine/LUI ответит им ошибкой, и поэтому рассчитывать на то, что наливка/преднастройка будут действительно отменяться, не стоит и нужно всегда исходить из предположения, что команда `force-status` отменяет операцию только в Wall-E, не пытаясь каким-либо образом откатить все действия, произведенные над хостом, или отменить активные операции в других сервисах.

Если вызвать команду `cancel-task` для хоста, переведенного в maintenance state другим пользователем, может возникнуть ошибка `The host is under maintenance by <other_user>`. Чтобы проигнорировать ее, используйте параметр `--ignore-maintenance`.


## Перемещение из проекта в проект {#project-switching}

Перенести машину из одного проекта в другой можно командой `wall-e hosts switch-project $host $project`. Хост будет перемещен as is: единственное, что в нем поменяется - это проект, которому он принадлежит.

При перемещении можно также указать опцию `-r/--release`, чтобы Wall-E перед сменой проекта вывел хост из эксплуатации. На данный момент под выводом из эксплуатации подразумевается выполнение следующих действий:
* Переключение в 999 VLAN
* Затирка дисков (прогоном преднастройки с деструктивными тестами диска)
* Удаление хоста из DNS
* Переименование хоста в BOT в `free-XXXXX.wall-e.yandex.net`
* Уведомление CMS проекта о выводе хоста из эксплуатации

Опция `--force` игнорирует проверку совместимости схем VLAN в проектах, после такого перемещения можно вручную кнопками починить VLAN и DNS на хосте.

Эта операция производится с уведомлением CMS проекта. В CMS отправляется задача с полем `action: "prepare"`. После того, как Wall-E удаляет эту задачу из CMS, хост выключен и готов к демонтажу. CMS проекта может запретить эту операцию, переведя задачу в статус `rejected`.

Операция вывода хоста из эксплуатации не будет производиться, если хост уже в стейте `free` – такое состояние означает, что хост уже выведен из эксплуатации.

{% note warning %}

Для корректной работы операции вывода хоста из эксплуатации проект должен быть настроен соответствующим образом: требования такие же, как и для операции [первоначальной настройки хостов](#host-preparing).

{% endnote %}


## Удаление сервера  {#removing}
В некоторых ситуациях сервер приходится удалять из Wall-E. Например, если его демонтируют. Сделать это можно командой `wall-e hosts remove $host`. При удалении хост может быть опционально удалён из LUI, для этого надо указать ключ `--lui`.


Эта операция производится с уведомлением CMS проекта. В CMS отправляется задача с полем `action: "deactivate"`. После того, как Wall-E удаляет эту задачу из CMS, хост удаляется из Wall-E. CMS проекта может запретить эту операцию, переведя задачу в статус `rejected`. CMS не уведомляется, если хост был в статусе `free` или если владелец проекта при удалении хоста указал флаг `--ignore-cms` или `--instant`.
