# Host Maintenance State

## Features {#description}
При переводе хоста в `maintenance state`, Wall-E идёт в CMS-API и создаёт задачу, как если бы хост отправили в починку или преднастройку. Отличие от преднастройки в том, что задача в CMS сохраняется (не удаляется) до тех пор, пока хост не будет переведён в `assigned state`. Всё это время также сохраняется downtime в Juggler-е. Конечно, есть опция `ignore-cms` – которая позволяет переводить хост в `maintenance state`, но не уведомлять об этом CMS-API, это не влияет на downtime в juggler-е.

Когда хост находится в maintenance state, его можно ребутать, переналивать и преднастраивать – при этом сохраняется его maintenance state. Если хост уведён в maintenance state с уведомлением CMS, то на ребуты и прочие задачи не создаётся отдельный запрос в CMS-API. Если же хост был уведён в maintenance state с `ignore-cms`, то для каждой задачи создаётся индивидуальный запрос, который удаляется при завершении задачи – как в случае с обычным статусом.

Будучи в maintenance state, хост может свалиться в `dead` – при этом Wall-E не потеряет maintenance state и хост не вернётся в эксплуатацию с точки зрения CMS-API.

Maintenance state имеет обязательный тайм-аут, после которого хост переводится в выбранный в самом начале статус: `ready` или `dead`. Также можно указать ключ тикета для maintenance, и при его закрытии хост сам перейдет в assigned state, если для него не установлен таймаут. Таймаут можно продлить или убрать в пользу тикета, попутно можно изменить статус, в который вернётся хост после завершения maintenance state. Вывести хост из maintenance state можно и самостоятельно. По истечению тайм-аута или закрытию тикета хост переводится в assigned state, но при этом он не включается автоматом – можно расчитывать, что его включит автоматика, которая посчитает выключенный хост сломанным.

{% note info %}

Чтобы Wall-E смог привязывать тикет к maintenance state, [robot-walle@](https://staff.yandex-team.ru/robot-walle) должен иметь право на чтение тикета. Можно либо перманентно настроить доступ для робота к очереди, либо добавить робота в список наблюдателей тикета.

{% endnote %}

## Interface
Новый maintenance state поддерживается [в нашем UI](https://wall-e.yandex-team.ru/projects/hosts) и в wall-e.cli начиная с версии 7.3.2.

Чтобы перевести хост или группу хостов в maintenance state, нужно воспользоваться кнопкой "Set maintenance" (`$ wall-e hosts set-maintenance` в cli). Для этого действия доступен привычный набор галочек (в частности, опция `ignore-cms`), а так же опция "Power Off", которая позволяет выключить хост на время работ.

![скриншот кнопки](../_assets/set_maintenance_button.png)

Чтобы изменить параметры maintenance state для хоста или группы хостов, можно воспользоваться кнопкой "Change maintenance" (`$ wall-e hosts change-maintenance` в cli).

Вернуть хосты из maintenance state можно по кнопке "Set assigned" (`$ wall-e hosts set-assigned` в cli). Для этого действия также доступен набор галочек (например, "Включить автопочинку Wall-E для этой операции"), а так же опция "Power On", чтобы включить хост, если он был выключен.

Все эти операции доступны также через [наше API](https://api.wall-e.yandex-team.ru).

## Backwards compatibility {#backwards-compatibility}
Старые кнопки, команды в cli и ручки в API назывались `force-status` и `power-off`. Сейчас эти кнопки и команды в cli сохраняются, равно как сохраняются и ручки в API – мы не любим отрывать функционал, потому что мы не любим ломать ваши скрипты. Для большей достоверности, кнопки в UI и команды в cli ходят в те самые старые ручки в API. Однако поведение API изменилось за кадром: теперь при переводе хоста в статус manual, Wall-E переводит его в maintenance state, а при переводе в статус ready или dead – возвращает в assigned. API для выключения хоста (`power-off`) теперь тоже переводит хост в maintenance state, с тайм-аутом по умолчанию.
