# Email-оповещения о событиях в проекте

Для каждого проекта можно указать список email-адресов, на которые Wall-E будет рассылать уведомления о событиях в проекте. Список email-адресов может быть разным для каждого severity.

В Wall-E оповещения могут иметь следующие severity:
* `audit` - По сути дает возможность получать [аудитный лог](audit_log.md) по почте. Может быть актуально только для очень небольших проектов - иначе будет слишком много писем. Содержимое данных оповещений в точности соответствует выводу `wall-e audit-log get --project $project` за исключением событий со статусом `rejected`.
* `info` - Действия над машинами (reboot/redeploy) со стороны API.
* `warning` - Автоматические действия над машинами (reboot/redeploy) со стороны Wall-E.
* `bot` - Отдельный severity для [заявок в Бот](../automation/admin_requests.md).
* `error` - Сообщения о переводе хоста в статусы `dead` и `invalid` (см [Статусы машин в Wall-E](host_statuses.md)), а также все [заявки в Бот](../automation/admin_requests.md).
* `critical` - Сообщения о включении/отключении автоматики для проекта.

Посмотреть текущую конфигурацию можно командой:
`$ wall-e projects notifications recipients get $project`

Список email-ов задается следующей командой:
`$ wall-e projects notifications recipients set --info $email1,$email2 --error $email3 $project`

Крайне рекомендуется, чтобы у каждого проекта был как минимум один человек, подписанный хотя бы на `bot` и `critical` - в противном случае вы можете пропустить очень важную информацию, касающуюся работы Wall-E с вашими машинами.

Помимо этого, все нотификации с severity >= info отправляются на [wall-e-notifications@](https://ml.yandex-team.ru/lists/wall-e-notifications/) без какого-либо деления на проекты.

**Важное замечание:**
На данный момент email-оповещения не являются надежными. Если произошло какое-то событие, и бэкенд, обрабатывающий это событие, по какой-либо причине не смог отправить пиьмо (к примеру, на машине упал SMTP-сервер), то данное письмо не будет доставлено, и никаких повторных попыток с других бэкендов производиться не будет. На данный момент абсолютно надежно события сохраняются только в [аудитном логе](audit_log.md) (при выполнении какого-либо действия информация об этом действии сначала записывается в лог, и только потом - выполняется).
