# Работа с предзаказами

Все сервера в Яндексе попадают к их владельцам через [механизм предзаказов в BOT](https://bot.yandex-team.ru/hwr/):
1. Владелец проекта оформляет предзаказ на необходимые ему сервера.
2. Ждет, когда они будут закуплены.
3. Забирает выданные машины из предзаказа.
4. Производит их первоначальную настройку, доводя до рабочего состояния.

Первый пункт может выполнить только человек, а вот остальные вполне можно доверить роботу, что позволяет сделать Wall-E:
1. Владелец проекта оформляет предзаказ на необходимые ему сервера и скармливает идентификатор предзаказа в Wall-E.
2. Wall-E периодически poll-ит текущее состояние предзаказа и при появлении новых машин отправляет их в [первоначальную настройку](hosts.md#host-preparing).
3. Как только заказ закрывается со стороны BOT, Wall-E обрабатывает оставшиеся машины и отправляет владельцу предзаказа письмо с информацией о том, какие машины были забраны, и какие ошибки произошли в процессе.

Предзаказ добавляется в Wall-E следующей командой:
`$ wall-e preorders add $preorder_id $project`

Если не указать никаких дополнительных опций, то единственное, что будет делать Wall-E - это забирать машины из предзаказа и добавлять в указанный проект.

Чтобы Wall-E автоматически отправил хосты в [первоначальную настройку](hosts.md#host-preparing), нужно указать ключик `--prepare` вместе с которым могут идти опциональные ключи `--provisioner`, `--config`, `--restrictions`, которые полностью аналогичны соответствующим ключам команды `hosts prepare`.

Посмотреть текущий статус предзаказа в Wall-E можно командой `wall-e preorders get $preorder_id`.

По завершении обработки владелец предзаказа получит письмо примерно следующего содержания:

> From: Wall-E <robot-walle@yandex-team.ru>
> Subject: [Wall-E] #3256 preorder has been processed
>
> Acquired hosts: 101450 101427.
> All acquired hosts have been added to 'search' project and sent to prepare stage.
>
> Failed hosts: 101260.
>
> The following errors have occurred during processing the preorder:
> * Failed to acquire ""#101260"": Host with ""#101260"" inventory number is not registered in BOT.
