# Проекты

Каждый хост, добавленный в Wall-E, принадлежит какому-либо проекту. Проект в понимании Wall-E - это группа хостов, образующая гомогенный кластер, который контроллируется одной CMS (Cluster Management System). Один хост может принадлежать только одному проекту. Здесь под словом "гомогенный" мы понимаем набор хостов, который конфигурируются одинаковым образом (наливка, VLAN-ы) и работают с одинаковыми настройками (автоматика, ограничения).

{% cut "Попробуем объяснить на примере." %}

В Яндексе есть Поиск. Он состоит из:
* Базовые Поиски
* Средние Поиски
* Поиск по картинкам
* и т. п.

Под весь Поиск выделена некая группа машин, которая принадлежит только ему - остальные проекты не могут размещать на них свои инстансы. Но в пределах своих машин CMS Поиска может располагать инстансы так, как посчитает нужным: к примеру, на одной физической машине разместить два базовых поиска и один - картиночный. Именно поэтому, в терминах Wall-E, у нас будет не несколько проектов (базовый, средний, картинки), а один - Поиск.

Таким образом, имея на руках какую-либо машину, Wall-E будет однозначно знать, что на ней располагаются только инстансы проекта X, и прежде чем произвести какие-либо действия над данной машиной, нужно согласовать их только с CMS этого проекта.

Дальше, в Яндексе открылся новый датацентр и в нём используется другая архитектура сети, вместо отдельного VLAN-а для каждого проекта, используется MTN. Более того, теперь старые датацентры постепенно мигрируют на новую схему сети. У Поиска есть сервера как в датацентрах с MTN, так и в старых датацентрах, которые ещё не закончили миграцию.

Кластер получается негомогенным, в нём есть два явных сегмента. Однако внутри сегмента конфигурация однородная и каждый сегмент может быть выражен отдельным проектом в Wall-E. По мере миграции старых сетей на MTN-схему, администратор может переносить хосты из legacy-проекта в mtn-проект, и Wall-E поможет в том числе и с переездом.

{% endcut %}

## Создание проекта {#adding-projects}
Проекты могут создавать администраторы Wall-e и пользователи (с небольшими ограничениями, касающимися CMS, об этом ниже).

### Создание проектов пользователями
При создании проекта пользователями учитывается тип указанной CMS -- кастомные CMS должны поддерживать TVM (при создании надо указать TVM application id CMS'а).

При создании проекта проверяется, что пользователь входит в указанный ABC-сервис. В дальнейшем Wall-E будет проверять, что сервера, которые добавляются в проект, принадлежат этому ABC-сервису.

Если у вас уже есть проект в Wall-E, то может быть проще [сделать клон существующего проекта](#cloning-projects) и отредактировать его параметры.

Создание проектов происходит через [UI Wall-e](https://wall-e.yandex-team.ru) или через консольный клиент.

### Создание проекта через UI
![form screenshot](../_assets/new_project_form.png)

### Создание проекта с помощью консольного клиента
Проект создается командой
`$ wall-e projects add $id $name --provisioner $provisioner --deploy-config $config [--owners $owners]`
* ID проекта - это его идентификатор, который будет фигурировать в API и CLI.
* Имя проекта - для отображения в UI (не должно быть длинным, чтобы уместиться в верстку).
* Provisioner (`eine` или `lui`) - наливайка, которая будет использоваться по умолчанию в проекте.
* Deploy config - конфиг, которым будут наливаться хосты, для которых не указано персональных настроек наливки (provisioner + config).

Если при создании проекта не указать владельцев, то владельцем будет назначен пользователь, который создал проект. В качестве настроек [email-нотификаций](notifications.md) по умолчанию выбирается "отправлять письма с severity `bot`, `warning` и `critical` всем владельцам проекта" (на самом деле было бы достаточно указать только `warning`, т. к. оно включает в себя `bot` и `critical`, но это сделано осознанно для того, чтобы зафорсить остальные severity, если пользователь, к примеру, решит отписаться от надоедливых `warning`) - поэтому, если проект создается админом не для себя, то лучше при создании проекта через опцию `--owners` сразу указывать владельцев проета.

По умолчанию проекту назначается default'ная CMS. Более подробно о CMS написано [здесь](../cms/general.md).

Проекты создаются с [выключенной автоматикой](../automation/general.md#automation-settings).

## Клонирование проектов {#cloning-projects}
Владелец проекта может клонировать свой проект. Это делается либо кнопкой "клонировать" в UI, либо командой в CLI
`$ wall-e projects clone <original_project_id> <clone_project_id> <clone_project_name> -m 'copying from project original_project_id, see TICKET-XXX'`

## Другие действия над проектами {#other-project-actions}
Существующие проекты можно посмотреть с помощью команды
`$ wall-e projects list`

Добавление машины в проект осуществляется командой
`$ wall-e hosts add $project $host`

У каждого проекта имеется набор свойств, которые можно менять (их список будет расти):
* Имя
* [Владельцы](authorization.md)
* [ABC сервис проекта](authorization.md#walle-abc)
* [Тип хостов](types.md)
* [Настройки хостов в CAuth](cauth.md)
* [CMS](../cms/general.md)
* [Список VLAN'ов, принадлежащих проекту](../automation/vlans.md#vlan-switching)
* [Профиль и теги преднастройки, которые будут использоваться по умолчанию для хостов](hosts.md#default-profile-configuration)
* Наливайка и конфиг наливки, которые будут использоваться по умолчанию для хостов
* [Ограничения (restrictions) по умолчанию для хостов](restrictions.md#default-restrictions)
* [Отключение автопочинки по проверкам](../automation/checks.md#checks-disabling)
* [Текущий статус автоматики (включена/выключена) ](../automation/general.md#automation-settings)
* [Ограничения на автоматику для защиты от уничтожения всего кластера](../automation/limits.md)
* [Настройки оповещения по email о событиях в проекте](notifications.md)
