# Ограничения (restrictions)
**Внимание!** Изменение ограничений, указанных в настройках проекта, не влияет на ограничения, настроенные для хостов. Ограничения, заданные в проекте, это ограничения по умолчанию, которые будут установлены для хоста *в момент его добавления*, если другие ограничения не были указаны. Текущие ограничения хоста определяются исключительно тем списком, который установлен для данного хоста - никакого неявного наложения списка ограничений из проекта не производится.

Для каждой машины можно задать одно или несколько ограничений из следующего списка:
* `automated-redeploy` - запрещает автоматическую [переналивку](hosts.md#host-deploying) хоста. Если Wall-E примет решение, что хост необходимо переналить, то при наличии такого ограничения он вместо переналивки просто переведет хост в статус `dead`.
* `automated-profile` - запрещает автоматическую [преднастройку](hosts.md#host-profiling) хоста. Если Wall-E примет решение, что хост необходимо отправить в преднастройку, то при наличии такого ограничения он вместо преднастройки просто переведет хост в статус `dead`.
* `automated-reboot` - запрещает автоматический [ребут](hosts.md#host-rebooting) хоста. Если Wall-E примет решение, что хост необходимо ребутнуть, то при наличии такого ограничения он вместо ребута просто переведет хост в статус `dead`. Неявно включает в себя `automated-profile`, `automated-redeploy` и `automated-memory-change`, т. к. они требуют перезагрузки машины.
* `automated-memory-change` - запрещает [автоматическую замену памяти](../automation/algorithm.md#automatic-memory-changing). Если Wall-E примет решение, что у хоста необходимо поменять планку памяти, то при наличии такого ограничения он вместо замены памяти просто переведет хост в статус `dead`.
* `automated-disk-change` - запрещает [автоматическую замену дисков](../automation/algorithm.md#automatic-disk-changing). Wall-E не будет пытаться лечить диски у хостов с этим ограничением. Также на замену дисков влияет ограничение `automated-redeploy` (и все, которые его включают): если оно есть у хоста, но нет ограничения `automated-disk-change`, то замена дисков будет производиться только в том случае, если она не ведет к потере данных.
* `automated-disk-cable-repair` - запрещает автоматическую замену SATA-кабеля.
* `automated-link-repair` - запрещает [автоматическую починку сетевого интерфейса](../automation/algorithm.md#automatic-link-repairing). Если Wall-E примет решение, что у хоста необходимо проверить сетевой интерфейс, то при наличии такого ограничения он вместо создания заявки в BOT просто переведет хост в статус `dead`.
* `automated-healing` - отключает автоматическое лечение хоста. Wall-E никогда не предпримет какие-либо действия автоматически - только по запросу от пользователя. Неявно включает в себя `automated-reboot`, `automated-profile`, `automated-redeploy`, `automated-memory-change`, `automated-disk-change` и `automated-link-repair`.
* `automated-dns` - запрещает [автоматическое исправление DNS-записей](../automation/dns.md#dns-fixing) хоста.
* `automation` - отключает всю автоматику для машины. Wall-E никогда не предпримет какие-либо действия автоматически - только по запросу от пользователя. Неявно включает в себя `automated-dns`, и `automated-healing`.
* `redeploy` - запрещает [переналивку](hosts.md#host-deploying) хоста. Как ручную, так и автоматическую. Неявно включает в себя `automated-redeploy`.
* `profile` - запрещает [преднастройку](hosts.md#host-profiling) хоста. Как ручную, так и автоматическую. Неявно включает в себя `automated-profile`.
* `reboot` - запрещает [ребут](hosts.md#host-rebooting) хоста. Как ручной, так и автоматический. Неявно включает в себя `automated-reboot`.

Добавление нового хоста с ограничением на переналивку:
`wall-e hosts add $project $host --restrictions redeploy`

Добавление нового хоста с ограничением на перезагрузку и переналивку (перезагрузка также запрещает и переналивку):
`wall-e hosts add $project $host --restrictions reboot`

Включение ограничений для уже существующего хоста:
`wall-e hosts modify $host --restrictions reboot`

Выключение всех ограничений для уже существующего хоста:
`wall-e hosts modify $host --restrictions ""`

Просмотр списка машин с информацией о ограничениях, включенных для них в данный момент:
`wall-e hosts list -C name,restrictions`


## Ограничения по умолчанию {#default-restrictions}

Если не указывать ограничения при добавлении хоста, то будут использоваться ограничения по умолчанию, указанные в проекте. Если при создании нового проекта не указать для него ограничения по умолчанию, то он будет создан без ограничений.

Эти ограничения никак не влияют на машины, которые уже существуют в проекте, они учитываются только при добавлении хоста в проект. Текущие ограничения хоста определяются исключительно тем списком, который установлен для данного хоста - никакого неявного наложения списка ограничений из проекта не производится.

Поменять ограничения по умолчанию для проекта можно командой
`$ wall-e projects modify --default-host-restrictions $restrictions $project_id`
