# Типы проектов и хостов в Wall-E:
На этапе создания проекта нужно выбрать один из поддерживаемых типов:
- server (железные сервера, имеющие определенный тип оборудования и инвентарный номер в oebs/bot)
- mac (macBook в Датацентрах, также имеющие определенный тип оборудования и инвентарный номер в oebs/bot)
- vm (виртуальные машины - пилот для проекта RTC в Azure/AWS)
- shadow-server (сервера, которые не были явно добавлены в Wall-E их владельцами, но добавлены автоматически для подключения их к сценариям регламентных работ Wall-E). Недоступно для выбора пользователям

Далее, при добавлении хостов в проект, тип хоста будет наследоваться из типа проекта, а также будет происходить соответствующая типу валидация. Отсюда следует, что в рамках одного проекта невозможно иметь хосты разного типа. 

## Ограничения:
- VM:
   - псевдо-инвентарный номер у VM генерится самим Wall-E при добавлении хоста из несуществующего диапазона (MAX_INT32, MAX_INT64]
   - location может быть задан пользователям через отдельную ручку API
   - нет никакого встроенного GC, т.к. нет единого source-of-truth для виртуальных машин. Команды должны сами реализовать GC поверх Wall-E API
   - (на момент написания документации) виртуальные машины не участвуют в процессах скрининга и лечения. 
   - недоступны никакие операции (ручные и автоматические) с данным типом хостов
- Shadow-проекты и shadow-сервера:
   - не участвуют в создании хостовых агрегатах и мониторинге здоровья через Juggler
   - недоступны никакие операции (ручные и автоматические, в том числе сценариев) с данным типом хостов
   - единственная доступная опция - переопределение Maintenance Plot-а для управления согласующими в сценариях
- Mac:
   - реализована лишь одна автоматическая реакция - в случае поломки по ssh или unreach будет создаваться тикет в ITDC.
