# Руководство по сценарию "itdc-maintenance"

Сценарий предназначен для сопровождения работ по перекату стоек в дата-центре.

Доступ к сценарию осуществляется через [IDM](https://idm.yandex-team.ru/#rf=1,rf-role=cTYH9Vus#walle/scenario/itdc-maintenance(fields:()),f-status=all,sort-by=-updated,rf-expanded=cTYH9Vus)

## Ограничения
- в рамках одного сценария возможно запросить сервера, принадлежащие только одной стойке;
- сценарии внедрены еще не на всех владельцев серверов. Текущий список подключенных к сценариям команд/владельцев: RTC, MDB, MDS, Sandbox MTN, Метрика.

{% note warning %}

На текущий момент для этого сценария осуществляется валидация - Wall-e проверяет, что все хосты из стойки/списка имеют хотя бы один из whitelist тегов или наличие сконфигурированного Maintenance Plot на проекте, к которому принадлежит хост.

Текущий список whitelist тегов: `"rtc"`

Если на вход попал хотя бы один хост, не проходящий валидацию, то Wall-e отдаст 400-ку и сообщение вида `"Host '<inv>' does not have any whitelist tags on it, whitelist tags: <current whitelist tags>"`

{% endnote %}

## Создание сценария через UI
Создать сценарий можно на странице [Scenarios](https://wall-e.yandex-team.ru/scenarios). Нажимаем кнопку "Create", в появившейся форме в выпадающем списке "Scenario type" выбираем тип "itdc-maintenance".
Заполняем форму:
- В поле "Ticket" указывает тикет в StarTrek'е, по которому проводятся работы. У робота [robot-walle@](https://staff.yandex-team.ru/robot-walle) должен быть доступ на чтение и создание комментариев в очереди StarTrek'а, или в этом конкретном тикете.
- В поле "Name" вводим краткое описание работ, которое будет отображаться в тикете с согласованием
- Переключатель "Resources" позволяет ввести список конкретных хостов ("Hosts"), или указать имя стойки ("Rack").
- В поле "Scheduled maintenance" следует указать дату и время начала работ.
- Установка галочки "Autostart" позволяет сразу же стартовать сценарий.

{% note warning %}

Настоятельно просим заполнять поле **"Scheduled maintenance"**.

Эта информация потребуется владельцам серверов для согласования работ, а также позволит автоматике Wall-E корректно спланировать снятие нагрузки с серверов к назначенному времени.

{% endnote %}


Список хостов можно задать в одном из трех форматов: "имя (fqdn)", "инвентарный номер (inv)" или "uuid", по одному на строке или через пробел.

Стойка - это строка вида `FI|MANTSALA|C|MAN-7#C.1.07|7C13`. Если указана стойка, Wall-e определит какие в ней находятся хосты, и добавит их в сценарий. Если в стойке есть хосты, не принадлежащие RTC (хосты в проектах, на которых не стоит тег `rtc`), сценарий не будет создан.

Также можно создать сценарий из основного интерфейса Wall-e: выбираем галочкой нужные хосты, в появившемся меню операций с выбранными хостами выбираем "Create scenario".

Пример заполненной формы:
![Screenshot](../_assets/scenario/itdc-maintenance-create-scenario-with-hosts.png)

### Проверка времени начала работ
Владельцы серверов имеют возможность указать за сколько часов до начала работ необходимо создать и запустить сценарий. Если при создании сценария было указано время начала работ, перед созданием сценария Wall-e проверит не слишком ли мало времени осталось до их начала. Если работы запланированы слишком скоро, сценарий создан не будет, выдастся ошибка:
![Screenshot](../_assets/scenario/scenario-creation-error-maintenance-start-time-is-too-soon.png)

Пример созданного, но еще не запущенного сценария:
![Screenshot](../_assets/scenario/itdc-maintenance-created-not-started.png)

При создании сценарий разобъет хосты на группы.


### Разбиение хостов на группы
При создании сценария каждому хосту назначается какая-то определенная группа в зависимости от свойств проекта, в который входит хост:
1. Если у проекта указан Maintenance Plot, хост попадает в группу "хосты с maintenance plot ID таким-то".
2. Если у проекта есть определенный тег, он попадает в группу "хосты с тегом таким-то".
3. (по умолчанию) Хост попадает в группу "хосты такого-то bot project ID, ABC-проект такой-то".

Конкретные теги, на основе которых могут быть созданы группы хостов (комментарий к п.2):
- Если у проекта хоста есть тег `yt` или `rtc.reboot_segment-yt_masters`, он добавляется в группу, согласование работ с хостами которой будет запрошено у админов YT - [k-malov@](https://staff.yandex-team.ru/k-malov) и [psushin@](https://staff.yandex-team.ru/psushin), сценарий нужно создавать за **2** суток до начала работ.
- Если у проекта хоста есть тег `yp`, он добавляется в группу, работы с которой подтверждают [текущие дежурные ABC-сервиса YP](https://abc.yandex-team.ru/services/yp/duty), сценарий нужно создавать за **3** суток до начала работ.
- Если у проекта хоста есть тег `yabs`, работы с ним подтверждает [bahbka@](https://staff.yandex-team.ru/bahbka), сценарий нужно создавать за **2** суток до начала работ.
- Работы со всеми остальными хостами подтверждают [kiranight23@](https://staff.yandex-team.ru/kiranight23) и [noiseless@](https://staff.yandex-team.ru/noiseless).

Wall-e создаст по одному согласованию для каждой из групп, прилинкует их к тикету, указанному при создании сценария, и будет ожидать аппрува на проведение работ для каждой из групп независимо от других. При получении согласования для хостов какой-то одной из групп, Wall-e перейдет к этапу вывода хостов этой группы в `maintenance` и их выключению.

Визуализация принадлежности хоста к какой-то группе в веб-интерфейсе есть на вкладке "State" сценария.

Запустим созданный сценарий кнопкой "Start".

---

## Ход работы сценария
Сценарий "itdc-maintenance" состоит из нескольких этапов:
1. Согласование работ с ответственными за сервера каждой из групп.
2. Выведение хостов каждой из групп в стейт `maintenance` и их выключение.
3. Ожидание завершения работ в дата-центре.
4. Ввод серверов обратно в работу.

Текущее состояние сценария можно отслеживать по label `WORK_STATUS`. Подробнее [тут](https://docs.yandex-team.ru/wall-e/guide/scenarios#tekushij-status-scenariya).

Рассмотрим каждый из этапов на примере [сценария 6577](https://wall-e.yandex-team.ru/scenarios/6577) , его тикет - [WALLE-4025](https://st.yandex-team.ru/WALLE-4025) .


### 1. Согласование работ с ответственными за сервера
Согласование реализовано на базе внутреннего яндексовского сервиса ["Ok"](https://wiki.yandex-team.ru/intranet/ok). Рассмотрим процесс согласования работ для каждой из групп хостов.
1. В очереди `RUNTIMECLOUD` создается тикет, привязанный к основному тикету сценария (позднее очередь будет изменена на `WALLEAPPROVES`).
2. В сервисе "Ok" создается согласование. Согласующие - это ответственные за хосты группы, координаторами назначаются "администраторы" ABC-сервиса [Регламентные операции](https://abc.yandex-team.ru/services/routineoperations). Согласующим на почту приходит письмо с призывом от сервиса "Ok", оно будет приходить ежедневно пока согласование не будет завершено.
3. В созданный на шаге 1 тикет добавляется комментарий, в который вставлен iframe со страницей согласования в сервисе "Ok", в этот комментарий призываются согласующие.
4. Ожидание получения резолюции "согласовано". Согласующие проходят в комментарий в тикете, или непосредственно на страничку согласования, и жмут "Ok" или "Не ок".

   4.1. Если нажат "Не Ок", согласование приостанавливается, но не закрывается. В комментарий в тикет призывается текущий дежурный ABC-сервиса [Регламентные операции](https://abc.yandex-team.ru/services/routineoperations).
 . Дежурный имеет права координатора, и может возобновить согласование, или остановить его. Если согласование будет возобовлено, полученный ранее "Не Ок" будет забыт, и система снова начнет ждать реакции согласующего. Если координатор завершит согласование, сейчас, на этапе прототипа, хосты этой группы просто никогда не будут выключены. Сценарий в этом случае подлежит отмене.

   4.2. Если нажат "Ок", согласование и тикет закрываются, а в основном тикете сценария появлется комментарий о том, что работы с хостами такой-то группы согласованы.

После получения согласования, начинается следующий этап - вывод хостов этой конкретной группы в `mantenance` и их выключение. Хосты групп, не получивших согласование, не перейдут к этому этапу.


### 2. Выведение хостов в стейт maintenance и их выключение
После получения согласования, хосты группы переводятся в стейт `maintenance` и выключаются. Чуть более подробно:

#### Для проектов с CMS версии v1.3:
1. Сценарий проверяет, что хост уже не обрабатывается каким-то другим сценарием, и привязывает его к себе.
2. Если в Maintenance plot проекта сконфигурирован соответствующий параметр ("Начинать снятие нагрузки через CMS за N часов до начала работ"), сценарий ожидает наступления сконфигурированного времени для следующего шага. Если параметр не настроен или в проекте не указан Maintenace plot - сценарий переходит к следующему шагу без ожидания.
3. На хост добавляется задача "set-host-maintenance" с обязательным походом в CMS (`"cms_action": "profile"`).
4. Если в Maintenance plot проекта сконфигурирован соответствующий параметр ("Выключать сервер за Х часов до начала работ"), сценарий ожидает наступления сконфигурированного времени для следующего шага. Если параметр не настроен или в проекте не указан Maintenace plot - сценарий переходит к следующему шагу без ожидания.
5. Сценарий выключает сервера через IPMI

#### Для проектов с default-CMS или с CMS версии ниже v1.3:
1. Сценарий проверяет, что хост уже не обрабатывается каким-то другим сценарием, и привязывает его к себе.
2. Если в Maintenance plot проекта сконфигурирован соответствующий параметр ("Начинать снятие нагрузки через CMS за N часов до начала работ"), сценарий ожидает наступления сконфигурированного времени для следующего шага. Если параметр не настроен или в проекте не указан Maintenace plot - сценарий переходит к следующему шагу без ожидания.
3. Сценарий меняет статус серверов на maintenance. **Важная особенность:** На данном этапе сценарий не проверяет лимиты default CMS на количество серверов в починке, т.к. считается, что ранее на этапе соглавания ответственный за сервера уже явно подтвердил через сервис ОК возможность выполнения данной регламентной работы
4. Если в Maintenance plot проекта сконфигурирован соответствующий параметр ("Выключать сервера за Х часов до начала работ"), сценарий ожидает наступления сконфигурированного времени для следующего шага. Если параметр не настроен или в проекте не указан Maintenace plot - сценарий не выключает хосты, заканчивает работы с данной группой и считает ее готовой к работам.
5. Если на предыдущем шаге указано значение параметра, сценарий выключает сервера через IPMI.


Стоит явно выделить, что ожидание согласования, выведение хостов в `maintenance` и их выключение происходит **параллельно** для всех групп хостов.

Пример состояния хостов сценария, находящихся в разных группах и на разных этапах:
![Screenshot](../_assets/scenario/itdc-maintenance-hosts-statuses-during-approvement.png)

Здесь:
- Первый хост - в ожидании согласования
- Второй хост - уже выключен
- Третий хост - выключается
- Четвертый хост - ожидает пока его отпустит CMS

Когда все хосты всех групп будут выключены, сценарий напишет об этом комментарий в основной тикет, и перейдет к следующему этапу.


### 3. Ожидание завершения работ в дата-центре
На этом этапе сценарий ничего не делает с хостами. Мячик переходит к сотрудникам ITDC, и они начинают физические операции с серверами. Когда работы с железом завершены, нужно нажать кнопку `Finish` в правом верхнем углу страницы сценария в UI Wall-E. Это завершит этап ожидания, и сценарий перейдет к возвращению хостов в работу.


### 4. Ввод серверов обратно в работу
Хосты последовательно проводятся через несколько этапов:
1. Сходи в Eine, проверь нет ли там активной задачи на преднастройку хоста, если есть - дождись ее выполнения.
2. Запомни текущий активный MAC-адрес хоста.
3. Запусти преднастройку хоста в Eine с тегом `swp-up`, чтобы Eine обновила у себя и у Wall-e имя свитча и номер порта, в который воткнут хост.
4. Переключи VLAN на свите и порту хоста в проектный.
5. Перезагрузи хост, если активный MAC-адрес хоста не поменялся.
6. Переналей хост, если активный MAC-адрес изменился (это значит, что преднастройку машин не прошла, и сотрудники ITDC заменили тушку).
7. Запусти процедуру "Check DNS" - сверь IP-адреса сервера с записями в DNS, обнови записи через DNS API если IP-адреса сервера изменились.
8. Переведи сервер в стейт `assigned` в Wall-e.

На этом работа сценария заканчивается.
Этапы ввода серверов обратно в работу можно выполнить вручную, в зависимости от ситуации с хостами после завершения работ ITDC.

---

## FAQ
Q: Что делать, если нужно выполнить какую-то операцию с хостами через Wall-e вне workflow сценария?

A: Поставить сценарий на паузу кнопкой "Pause" справа сверху, проделать операции, стартануть сценарий кнопкой "Start".

Q: Какие есть ограничения у сценария?

A: В данным момент сценарии itdc-maintenance/noc-hard работают только с серверами RTC. При этом для RTC-серверов есть ограничения по срокам и количеству выводимых серверов, которые отражены в [регламенте RTC](https://rtc.yandex-team.ru/docs/operations/rack-maintenance).
Подключение других владельцев серверов также планируется, но требует некоторого времени.
