# Руководство по "Maintenance plot"

**"Maintenance plot"** - это форма (набор опций), которая определяет поведение Wall-E при работе с хостами определенного проекта (или проектов) при проведении регламентных работ NOC/ITDC (сценарии Wall-E). Например, "как и с кем согласовывать работы с вашими серверами?", "как и когда снимать нагрузку через CMS?" и т.д. (подробнее о поддерживаемых настройках - ниже).

В настоящий момент находится в "гармошке" **Configure** в шапке UI, в пункте под названием **Maintenance Plots**.

## Использование

Для того, чтобы использовать maintenance plot требуется сделать следующее:
1. Создать maintenance plot через UI (кнопка Create)
2. Привязать его к проекту (на страничке проекта, пункт Maintenance plot в разделе Checks)


Более подробно о создании и параметрах ниже.

## Параметры

### Основные параметры

Каждый maintenance plot должен иметь:
1. Plot name - название (желательно коррелюрующее с сервисом, который он будет эксплуатировать)
2. ABC Service Slug - slug ABC сервиса, члены которого будут управлять создаваемым maintenance plot'ом

### Maintenance Approvers

#### Апруверы

1. Logins - логины пользователей
2. ABC Roles Codes - коды ролей, которые будут использоваться для сбора логинов пользователей из ABC сервиса
3. ABC Role Scope Slugs - Scope Slugs по которым будут собираться логины пользователей из ABC сервиса
4. ABC Duty Schedule Slugs - Slug дежурства ABC сервиса

Логика аггрегации логинов пользователей работает по принципу UNION: Wall-e соберет все логины по всем указаным кодам/slug'ам, а затем будет использовать их для призывов в согласования работ и/или во время проблем с хостами.

#### Общие ограничители

1. dont_allow_start_scenario_if_total_number_of_active_hosts_more_than - опция, которая заблокирует запуск новых сценариев, если общее количество задействованных хостов из нового сценария и всех активных старых больше, чем указанное в опции
2. total_number_of_active_hosts - опция, которая позволяет не создавать согласования для хостов из maintenance plot'а, если общее количество задействованных хостов из нового сценария и всех активных старых меньше, чем указанное в опции

### Scenario Settings

Для каждого plot'а можно задать специфические параметры, которые будут использовать в отдельных видах регламентных работ.

#### ITDC-Maintenance

1. Reject if maintenance starts too soon - минимальное время, необходимое вам на весь процесс подготовки серверов от создания тикета до выключение, которое отсчитывает от даты создания сценария до плановой даты начала работ. Полезно, если требуется провести какую-то валидация сразу на старте сценария
2. Start requesting CMS beforehand* - за сколько часов до плановой даты начала работ начинать ходить в вашу CMS
3. Call when maintenance starts - за сколько часов до начала работ призывать в тикет ответственных, если CMS все еще не отдала хосты
4. Start poweroff beforehand - за сколько часов до плановой даты начала работ выключать сервера через IPMI
5. Redeploy on MAC address change - проводить ли редеплой хостов после смены mac адресов (замены сетевых карточек)
6. Call beforehand - призывать ли ответственных в тикет, если время начала работ наступило, а CMS все еще не отдала хосты
7. Ignore CMS on host operations - ходить ли в проектные CMS во время хостовых операций (увод в maintenance, ребуты, выключения)
8. Manual approval after hosts power off - создавать ли отдельное согласование для ручного подтверждения подготовки хостов к работам (выключает автоматический возврат хостов)

#### Noc-hard

1. Reject if maintenance starts too soon - минимальное время, необходимое вам на весь процесс подготовки серверов от создания тикета до выключение, которое отсчитывает от даты создания сценария до плановой даты начала работ. Полезно, если требуется провести какую-то валидация сразу на старте сценария
2. Start requesting CMS beforehand* - за сколько часов до плановой даты начала работ начинать ходить в вашу CMS
3. Call when maintenance starts - за сколько часов до начала работ призывать в тикет ответственных, если CMS все еще не отдала хосты
4. Redeploy on MAC address change - проводить ли редеплой хостов после смены mac адресов (замены сетевых карточек)
5. Call beforehand - призывать ли ответственных в тикет, если время начала работ наступило, а CMS все еще не отдала хосты
6. Ignore CMS on host operations - ходить ли в проектные CMS во время хостовых операций (увод в maintenance, ребуты, выключения)
7. Manual approval after hosts power off - создавать ли отдельное согласование для ручного подтверждения подготовки хостов к работам (выключает автоматический возврат хостов)
