# Руководство по сценарию "noc-soft"

Сценарий предназначен для выполнения разгрузки серверов для проведения **быстрых работ со свитчём**.

Быстрые работы — это работы, которые:
- должны занимать меньше 30 минут;
- не нести изменений с точки зрения коммутации/ip-адрессации серверов, участвующих в работах.

Если работы будут длится более 30 минут или в результате работ меняется коммутация/ip-адрессация подключенных серверов (например замена свича), то вам нужен другой сценарий — долгий NOC сценарий ([noc-hard](https://docs.yandex-team.ru/wall-e/scenario/noc-hard)).

Получить права на управление данным типом сценариев можно через [IDM](https://idm.yandex-team.ru/#rf=1,rf-role=cTYH9Vus#walle/scenario/noc-soft(fields:()),f-status=all,sort-by=-updated,rf-expanded=cTYH9Vus).

## Ограничения
- в рамках одного сценария возможно запросить сервера, принадлежащие только одному свитчу;
- в данный момент работа сценария данного типа полноценно поддержана для серверов `YP, YT, MDB, MDS, YDB-prestable`. Для всех остальных серверов происходит простое выключение автоматики починки Wall-E на время работ (перевод в maintenance без уведомления CMS), поэтому на данном этапе развития требуется согласование работ с владельцами серверов, не поддерживающих механизм noc-soft сценариев Wall-E;
- в данный момент невозможен отложенный старт сценария. При старте сценарий сразу приступает к разгрузке серверов через CMS в соответствии с пунктом данного документа "Ход работы сценария";
- также существуют общие лимиты на количество сценариев данного типа:
  * не более двух активных сценариев в одном ДЦ;
  * не более шести активных сценариев типа **noc-soft** всего;
-  для полноценного завершения сценария все хосты должны быть успешно переведены в state assigned, проследить за этим - обязанность запустившего сценарий. Если этого не происходит, то стоит проверить не произошло ли во время/в результате работ какой-нибудь не предвиденной поломки;

## Создание сценария
Создать сценарий можно на странице [Scenarios](https://wall-e.yandex-team.ru/scenarios). Нажимаем кнопку "Create", в появившейся форме в выпадающем списке "Scenario type" выбираем тип "noc-soft".
Заполняем форму:
- В поле "Ticket" указывает тикет в StarTrek'е, по которому проводятся работы. У робота [robot-walle@](https://staff.yandex-team.ru/robot-walle) должен быть доступ на чтение и создание комментариев в очереди StarTrek'а, или в этом конкретном тикете.
- В поле "Name" вводим произвольное имя сценария.
- В поле "Switch" вводим имя свитча.
- Установка галочки "Autostart" позволяет сразу же стартовать сценарий.

## Ход работы сценария
* Для начала проверяются некоторые лимиты:
  * не более двух актвных сценариев в одном ДЦ
  * не более шести активных сценариев типа **noc-soft** всего
* Хосты запрашиваются для проведения быстрых работ у тех CMS, которые это поддерживают. Речь идёт про action `TEMPORARY_UNREACHABLE` и подробнее про это расписано [тут](https://docs.yandex-team.ru/wall-e/cms/soft_maintenance) и [тут](https://docs.yandex-team.ru/wall-e/cms/v1.4). В настоящий момент, чтобы добавить свою CMS в список поддерживающих быстрые NOC работы, надо завести тикет в очереди [WALLESUPPORT](https://st.yandex-team.ru/WALLESUPPORT)
* Если CMS не отдала хост за 30 минут, то работы отменяются и сценарий переводится в статус rejected
* Когда CMS отдали все хосты и они готовы к работам (переведены в maintenance), сценарий переводится в статус `ready`. В этот момент NOC может начинать работы на свитче
* После окончания работ NOC должны сообщить об это walle через API (см. ниже) или нажав кнопку `Finish` в UI walle на странице сценария.
* После этого Walle начинает возвращать хосты в эксплуатацию.

## Работа через API
Список всех ручек API доступен по адресу https://api.wall-e.yandex-team.ru/

Немного примеров для создания и управления сценарием:
* создание
  ```
  curl -X POST https://api.wall-e.yandex-team.ru/v1/scenarios \
    -d '{"name": "noc hard test", "scenario_type": "noc-soft", "ticket_key": "TICKET-66", "script_args": {"switch": "vla1-1s84"}}' \
    -H 'Content-Type: application/json' -H 'Authorization: OAuth <token>'
  ```
* сигнал окончания работ со стороны NOC и начало возврата хостов в работу после работ:
   ```
   curl -X PATCH https://api.wall-e.yandex-team.ru/v1/scenarios/<id> \
     -d '{"labels": {"WORK_COMPLETED": "true"}}' \
     -H 'Content-Type: application/json' -H 'Authorization: OAuth <token>'
   ```

