# Руководство по регламентным работам в Wall-e для новых пользователей

{% note warning %}

Q: Я не знаю, что такое Wall-e (никуда свои хосты не добавлял) и не понимаю зачем меня призвали. Wall-e будет что-то делать с моим железом?
A: Нет, не будет. Вас попросят согласовать работы на определенную дату, а затем подтвердить, что ваши хосты выключены (или готовы к работам в ином виде).

{% endnote %}

NOC и ITDC проводят все свои работы (замена/переналивка свитчей, переезды стоек, etc) через Wall-e.

Что это значит для пользователей, которые пользуются автоматикой Wall-e для проведения регламентых работ:
1) Wall-e сможет самостоятельно запрашивать хосты из CMS (как с согласованием, так и без)
2) Wall-e будет осуществлять возврат хостов в продовое состояние (перетыкнет вланы, проверит работоспособность хостов, начнет чинить сломанное)

Что это значит для пользователей, которые занесли хосты в Wall-e, но не пользуются автоматикой:
1) Wall-e будет запрашивать разрешение на проведение работ через тикеты
2) Пользователям нужно самостоятельно проводить выключение хостов (aka уводить хосты в maintenance)
3) Wall-e ничего не будет делать с хостами, возврат хостов осуществляется пользователями самостоятельно

Что это значит для всех прочих пользователей:
1) Wall-e будет запрашивать у вас согласование работ на определенную дату, а затем подтвердение, что ваши хосты выключены (или готовы к работам в ином виде)
2) Wall-e ничего не будет делать с хостами, возврат хостов осуществляется пользователями самостоятельно

---

## Для пользователей которые хотели бы пользоваться автоматикой

У нас есть документация по отдельным видам регламентых работ:
1) [работы ITDC](https://docs.yandex-team.ru/wall-e/scenario/itdc-maintenance)
2) [работы NOC с недоступностью хостов > 30 минут](https://docs.yandex-team.ru/wall-e/scenario/noc-hard)
3) [работы NOC с недоступностью хостов <= 30 минут](https://docs.yandex-team.ru/wall-e/scenario/noc-soft)

Также есть документик, где расписано какие опции/настройки сейчас доступны (и как их подключить).
Посмотреть можно [тут](https://docs.yandex-team.ru/wall-e/scenario/maintenance-plots)

Если у вас остались вопросы, либо вам не хватает опций/нужны улучшения, приходите в [очередь](https://st.yandex-team.ru/WALLESUPPORT)


## Для пользователей хосты которых находятся в Wall-e, но не используют автоматику

Порядок работ сейчас такой:
1) Wall-e создает согласование даты работ с хостами, ждет подтверждения
2) После ОК'а Wall-e создает согласование с подтверждением о том, что хосты выключены
3) После OK'а Wall-e сообщает в ITDC/NOC о том, что работы можно проводить
4) После выполнения работ Wall-e сообщит о том, что хосты можно включить/возвращать в продовое состояние
Ни на каком из шагов Wall-e не пытается что-либо сделать с хостами самостоятельно.

Согласующие работ по умолчанию - "owners" проектов, где находятся хосты.

Мы настоятельно рекомендуем:
1) выключать хосты через Wall-e (aka уводить хосты в maintenance), т.к. это позволяет минимизировать различные сайд-эффекты во всех системах которые мониторят живость датацентров
2) завести свой собственный [maintenance-plot](https://docs.yandex-team.ru/wall-e/scenario/maintenance-plots) - так вы сможете настроить согласующих (например, оставить лишь определенную роль или дежурного)
3) придти в [очередь](https://st.yandex-team.ru/WALLESUPPORT) и попросить провести "учения" над вашими хостами с выставленными вами настройками


## Для пользователей, которые не используют Wall-e

Порядок работ сейчас такой:
1) Wall-e создает согласование даты работ с хостами, ждет подтверждения
2) После ОК'а Wall-e создает согласование с подтверждением о том, что хосты выключены
3) После OK'а Wall-e сообщает в ITDC/NOC о том, что работы можно проводить
4) После выполнения работ Wall-e сообщит о том, что хосты можно включить/возвращать в продовое состояние
Ни на каком из шагов Wall-e не пытается что-либо сделать с хостами самостоятельно.

Согласующие работ по умолчанию - "руководители сервисов" и "управляющие железными ресурсами" в ABC сервисе к которому привязаны хосты.
Согласующих можно поменять, для этого:
1) Перейдите на https://wall-e.yandex-team.ru/maintenance_plots/shadow-[X], где вместо [X] подставьте ABC service id
2) На вкладке "Maintenance approvers" можно указать какие роли/дежурства призывать для согласования

Q: Я нашел свой хост в Wall-e, могу ли я выключить через Wall-e?
A: Нет. Если вы хотите пользоваться включением/выключением хостов, нужно завести проект и добавить туда хосты.

Q: Раньше я просто получал письма и ничего не подтверждал, можно ли вернуться к этому поведению?
A: Нет. Как показывает практика, такое поведение было факапоопасным.

Q: Я все прочитал и все равно ничего не понял, куда мне обращаться?
A: В [очередь](https://st.yandex-team.ru/WALLESUPPORT). Мы обязательно придем и поможем.
