import os

import yalibrary.svn as svn
from library.python.find_root import detect_root


def arcadia_root():
    return detect_root(os.getcwd())


def relative(path):
    return os.path.relpath(path, arcadia_root())


def commit(paths, message, skip_check=False):
    svn.svn_commit(paths, msg=message, revprops={"arcanum:check-skip": "yes"} if skip_check else None)


def get_last_commit(path):
    info = svn.svn_info(path)
    return int(info['commit_revision'])


def get_commit_messages_since_last_changelog(path, changelog_path):
    change_log_commit = get_last_commit(changelog_path)
    last_commit = get_last_commit(path)

    if change_log_commit == last_commit:
        return []

    return [msg.splitlines(False)[0]
            for msg in _get_commit_messages(path, change_log_commit+1, last_commit)]


def _get_commit_messages(path, start_revision, end_revision):
    commits = svn.svn_log(path, revision_from=start_revision, revision_to=end_revision)
    return [ci['msg'] for ci in commits]
