import logging
import sys


def release_message(prefix, package_versions):
    """

    :param prefix:
    :type package_versions: [(pkgname_str, version_str|None), ...]
    """
    if not package_versions:
        # we do not want to raise exception on this stage, release has been committed already.
        return "The new release"

    packages = []
    for package_name, version in package_versions:
        if version is None:
            packages.append(package_name)
        else:
            packages.append("{} v{}".format(package_name, version))

    return "{} {}".format(prefix, join_with_and(packages))


def join_with_and(strings, comma=",", and_str="and"):
    comma = comma + " "
    and_str = " " + and_str + " "

    if len(strings) <= 1:
        return "".join(strings)

    return and_str.join([comma.join(strings[:-1]), strings[-1]])


def setup_logging(verbose):
    level = logging.INFO - verbose * 10
    level = logging.getLevelName(level)

    logging.addLevelName(logging.DEBUG, "D")
    logging.addLevelName(logging.INFO, "I")
    logging.addLevelName(logging.WARNING, "W")
    logging.addLevelName(logging.ERROR, "E")
    logging.addLevelName(logging.CRITICAL, "C")

    console = logging.StreamHandler(sys.stdout)
    formatter = logging.Formatter('%(levelname)s: %(message)s')
    console.setFormatter(formatter)

    root_logger = logging.getLogger('')
    root_logger.addHandler(console)
    root_logger.setLevel(level)
