"""Wall-E API client setup script."""

from __future__ import unicode_literals

import imp
import os

from setuptools import find_packages, setup

PACKAGE_PATH = os.path.abspath(os.path.dirname(__file__))


def get_version():
    module_path = os.path.join(PACKAGE_PATH, "walle_api", "constants.py")

    module = imp.new_module("walle_constants")
    module.__file__ = module_path

    with open(module_path) as module_file:
        module_contents = module_file.read()

    exec(compile(module_contents, module_path, "exec"), module.__dict__)

    return module.version


def get_description():
    with open(os.path.join(PACKAGE_PATH, "README")) as readme:
        return readme.read()


def get_requirements():
    requirements = []
    path = os.path.join(PACKAGE_PATH, "requirements.txt")

    with open(path) as requirements_txt:
        for requirement in requirements_txt:
            requirement = requirement.strip()
            if requirement and not requirement.startswith("#"):
                requirements.append(requirement)

    return requirements


setup(
    name="wall-e.api",
    version=get_version(),
    description="API client for Wall-E (Hardware as a Service)",
    long_description=get_description(),
    author_email="wall-e@yandex-team.ru",
    url="https://abc.yandex-team.ru/services/Wall-E/",

    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: System Administrators",
        "Operating System :: MacOS",
        "Operating System :: POSIX :: Linux",
        "Programming Language :: Python :: 2.7",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
    platforms=["linux", "osx"],

    install_requires=get_requirements(),
    packages=find_packages(),
)
