resource "yandex_kms_symmetric_key" "kms_key" {
  name              = var.kms_key_name
  default_algorithm = "AES_256"
}

resource "yandex_kubernetes_cluster" "mk8s_cluster" {
  name = var.mk8s_cluster_settings.name
  network_id = var.mk8s_cluster_settings.master_network_id

  master {
    regional {
      region = var.mk8s_cluster_settings.master_region

      dynamic "location" {
        for_each = var.mk8s_cluster_settings.master_zone_ids_subnet_ids
        content {
          zone      = location.key
          subnet_id = location.value
        }
      }
    }

    version   = var.mk8s_cluster_settings.version
    public_ip = false
    maintenance_policy {
      auto_upgrade = false
    }
  }

  cluster_ipv4_range = "10.20.0.0/16"
  service_ipv4_range = "10.21.0.0/16"
  cluster_ipv6_range = "fc00::/96"
  service_ipv6_range = "fc01::/112"

  service_account_id      = var.mk8s_cluster_settings.service_account_id
  node_service_account_id = var.mk8s_cluster_settings.node_service_account_id

  release_channel = var.mk8s_cluster_settings.release_channel

  kms_provider {
    key_id = yandex_kms_symmetric_key.kms_key.id
  }

  timeouts {
    create = "30m"
  }
}
