resource "yandex_kubernetes_node_group" "walle_mk8s_nodegroup" {
  name       = var.mk8s_nodegroup_settings.name
  cluster_id = var.mk8s_nodegroup_settings.mk8s_cluster_id
  version = var.mk8s_nodegroup_settings.mk8s_cluster_version

  allocation_policy {
    dynamic "location" {
      for_each = var.mk8s_nodegroup_settings.zone_ids
      content {
        zone = location.value
      }
    }
  }

  instance_template {
    platform_id = var.instance_template_settings.platform_id
    metadata = {
      ssh-keys = file(var.instance_template_settings.metadata.ssh_keys_file_path)
    }

    boot_disk {
      size = var.instance_template_settings.boot_disk.size
      type = var.instance_template_settings.boot_disk.type
    }

    network_interface {
      security_group_ids = var.instance_template_settings.network_interface.security_group_ids
      subnet_ids = var.instance_template_settings.network_interface.subnet_ids
      ipv4               = true
      ipv6               = true
    }

    resources {
      core_fraction = var.instance_template_settings.resources.core_fraction
      cores         = var.instance_template_settings.resources.cores
      memory        = var.instance_template_settings.resources.memory
    }
  }

  scale_policy {
    fixed_scale {
      size = var.mk8s_nodegroup_settings.size
    }
  }
}
