variable "mk8s_nodegroup_settings" {
  type = object({
    name = string
    mk8s_cluster_id = string
    mk8s_cluster_version = string
    zone_ids = list(string)
    size = number
  })
}

variable "instance_template_settings" {
  type = object({
    platform_id = string
    metadata = object({
      ssh_keys_file_path = string
    })
    boot_disk = object({
      size = number
      type = string
    })
    network_interface = object({
      security_group_ids = list(string)
      subnet_ids = list(string)
    })
    resources = object({
      core_fraction = number
      cores         = number
      memory        = number
    })
  })
}
