resource "ycp_vpc_network" "main_network" {
  folder_id = var.cloud.folder_id
  name      = var.main_network.name
}

resource "ycp_vpc_subnet" "main_subnets" {
  for_each = var.main_subnets.subnets

  folder_id         = var.cloud.folder_id
  name              = each.value.name
  network_id        = ycp_vpc_network.main_network.id
  zone_id           = each.value.zone_id
  v4_cidr_blocks    = each.value.ipv4_subnets
  v6_cidr_blocks    = each.value.ipv6_subnets
  egress_nat_enable = each.value.egress_nat_enable

  # YCLOUD-3725
  extra_params {
    export_rts  = ["65533:666"]
    import_rts  = ["65533:776"]
    hbf_enabled = true
    rpf_enabled = false
  }
}

locals {
  _zone_ids       = { for subnet, subnet_params in var.main_subnets.subnets : subnet => subnet_params.zone_id }
  zone_ids_subnet_ids = { for zone_key, subnet in ycp_vpc_subnet.main_subnets : local._zone_ids[zone_key] => subnet.id}

  v4_cidr_blocks = [for _, subnet in ycp_vpc_subnet.main_subnets : subnet.v4_cidr_blocks[0]]
  v6_cidr_blocks = [for _, subnet in ycp_vpc_subnet.main_subnets : subnet.v6_cidr_blocks[0]]
}
