resource "ycp_vpc_address" "ip_address" {
  name = var.ip_address_name
  ipv6_address_spec {
    requirements {
      hints = ["yandex-only"]
    }
  }
  reserved = true
}

resource "ycp_dns_dns_record_set" "dns_record" {
  zone_id = var.dns_zone_id
  name    = var.dns_record_name
  type    = "AAAA"
  ttl     = 600
  data    = [ycp_vpc_address.ip_address.ipv6_address[0].address]
}
