import json
import sys

import requests

SECRET_VERSIONS_URL = 'https://vault-api.passport.yandex.net/1/secrets/{}'
SECRET_VERSION_URL = 'https://vault-api.passport.yandex.net/1/versions/{}'


def main():
    input = json.load(sys.stdin)

    id = input['id']
    oauth = input['yav_oauth']
    value_name = input['value_name']

    oauth_headers = {'Authorization': 'OAuth {}'.format(oauth)}
    resp = requests.get(SECRET_VERSIONS_URL.format(id), headers=oauth_headers)
    version = resp.json()['secret']['secret_versions'][0]['version']
    resp = requests.get(SECRET_VERSION_URL.format(version), headers=oauth_headers)

    output = {
        'id': id,
        'version': version,
        'secret': None
    }
    for value in resp.json()['version']['value']:
        output[value['key']] = value['value']
        if value_name == value['key']:
            output['secret'] = value['value']

    print(json.dumps(output))


if __name__ == '__main__':
    main()
