resource "yandex_kms_symmetric_key" "tfstate_s3_kms_master_key" {
  name              = var.tfstate_s3_kms_master_key.name
  description       = var.tfstate_s3_kms_master_key.description
  labels            = {}
  default_algorithm = var.tfstate_s3_kms_master_key.default_algorithm
}

resource "yandex_iam_service_account_static_access_key" "tfstate_s3_sa_static_key" {
  service_account_id = var.tfstate_s3_sa_static_key.service_account_id
  description        = var.tfstate_s3_sa_static_key.description
}

resource "yandex_storage_bucket" "tfstate_s3_storage" {
  bucket     = var.tfstate_s3_storage.bucket
  access_key = yandex_iam_service_account_static_access_key.tfstate_s3_sa_static_key.access_key
  secret_key = yandex_iam_service_account_static_access_key.tfstate_s3_sa_static_key.secret_key
  server_side_encryption_configuration {
    rule {
      apply_server_side_encryption_by_default {
        kms_master_key_id = yandex_kms_symmetric_key.tfstate_s3_kms_master_key.id
        sse_algorithm     = var.tfstate_s3_storage.sse_algorithm
      }
    }
  }

  # Versioning is disabled here, because of error 'Error putting S3 versioning: AccessDenied'.
  # Granting 'storage.admin' role to SA running this spec,
  # as https://cloud.yandex.com/en-ru/docs/storage/security/#service-roles suggests,
  # does not change the error.
  # One should enable versioning, if needed, manually in Cloud UI.
  #
  # versioning {
  #   enabled = true
  # }
}

locals {
  yav_secret_payload = jsonencode({
    access_key = yandex_iam_service_account_static_access_key.tfstate_s3_sa_static_key.access_key
    secret_key = yandex_iam_service_account_static_access_key.tfstate_s3_sa_static_key.secret_key
    endpoint   = var.yav_secret.payload_storage_endpoint
    bucket     = var.tfstate_s3_storage.bucket
  })
}

resource "null_resource" "yav_secret" {

  # To recreate this resource, one must 'taint' it first:
  # https://www.terraform.io/cli/commands/taint
  #
  # [ tfstate ] $ terraform taint null_resource.yav_secret
  # Resource instance null_resource.yav_secret has been marked as tainted.
  # [ tfstate ] $
  #
  # After tainting, run 'plan' and 'apply' as usual.
  # Do not forget to delete old version of the secret from Yandex Vault.

  provisioner "local-exec" {
    command = <<-EOT
      ya vault create secret '${var.yav_secret.name}' \
      --roles ${var.yav_secret.permissions}           \
      --value '${local.yav_secret_payload}'           \
      --tags '${var.yav_secret.tags}'                 \
      --comment '${var.yav_secret.comment}'           \
      --json
    EOT
  }
}
