cloud = {
  cloud_id  = "yc.wall-e.cloud"
  folder_id = "yc.wall-e.main-folder"
}

provider_yandex = {
  endpoint         = "api.cloud.yandex.net:443"
  storage_endpoint = "storage.yandexcloud.net:443"
}

tfstate_s3_kms_master_key = {
  name              = "terraform-state-s3-storage-encryption-key"
  description       = "Terraform State S3 Storage KMS master key"
  default_algorithm = "AES_256"
}

tfstate_s3_sa_static_key = {
  service_account_id = "yc.wall-e.terraform-s3-state-sa"
  description        = "Terraform State S3 Storage static access key"
}

tfstate_s3_storage = {
  bucket        = "terraform-state-s3-storage"
  sse_algorithm = "aws:kms"
}

yav_secret = {
  name                     = "yc-walle-prod-terraform-state-s3-storage"
  comment                  = "Secrets to S3 bucket terraform-state-s3-storage in YC prod yc.wall-e.cloud cloud, yc.wall-e.main-folder folder."
  permissions              = "owner:abc:yc_wall_e:scope:administration"
  tags                     = "wall-e,walle,yc"
  payload_storage_endpoint = "storage.yandexcloud.net"
}
