#!/usr/bin/env bash

set -Eeuo pipefail

# Variables for cloud "yc.wall-e.cloud" folder "yc.wall-e.main-folder" in production YC.
YC_STAGE_PROD="prod"
TFVARS_FILE_NAME_PROD="prod-yc.wall-e.cloud.tfvars"
YC_SA_PROFILE_NAME_PROD="prod-yc.wall-e.main-sa"
YCP_SA_PROFILE_NAME_PROD="prod-yc.wall-e.main-sa"

# Variables for cloud "yc.wall-e.cloud" folder "yc.wall-e.main-folder" in prestable YC.
YC_STAGE_PREPROD="preprod"
TFVARS_FILE_NAME_PREPROD="preprod-yc.wall-e.cloud.tfvars"
YC_SA_PROFILE_NAME_PREPROD="preprod-yc.wall-e.main-sa"
YCP_SA_PROFILE_NAME_PREPROD="preprod-yc.wall-e.main-sa"

# Variables for cloud "yc.wall-e.cloud-testing" folder "yc.wall-e.main-testing-folder" in prestable YC.
YC_STAGE_TESTING="testing"
TFVARS_FILE_NAME_TESTING="testing-yc.wall-e.cloud.tfvars"
YC_SA_PROFILE_NAME_TESTING="preprod-yc.wall-e.main-sa-testing"
YCP_SA_PROFILE_NAME_TESTING="preprod-yc.wall-e.main-sa-testing"

# Manage CLI arguments.
USAGE="Usage: $(basename "$0") -s [prod] some terraform commands"

while getopts ":s:" opt; do
  case "$opt" in
    s) YC_STAGE=${OPTARG} ;;
    \?) echo "Invalid option -$OPTARG" >&2
    ;;
  esac
done

if [ "${YC_STAGE:-not-specified}" = "not-specified" ];
then
    echo "${USAGE}"
    exit 1
fi

shift $(( OPTIND - 1 ))
TERRAFORM_COMMAND=("$@")

if [ "${#TERRAFORM_COMMAND[@]}" -eq 0 ];
then
    echo "${USAGE}"
    exit 1
fi

# Set variables according to provided stage name.
if [ "${YC_STAGE}" = "${YC_STAGE_PROD}" ];
then
    TFVARS_FILE_NAME="${TFVARS_FILE_NAME_PROD}"
    YC_SA_PROFILE_NAME="${YC_SA_PROFILE_NAME_PROD}"
    YCP_SA_PROFILE_NAME="${YCP_SA_PROFILE_NAME_PROD}"
elif [ "${YC_STAGE}" = "${YC_STAGE_PREPROD}" ];
then
    TFVARS_FILE_NAME="${TFVARS_FILE_NAME_PREPROD}"
    YC_SA_PROFILE_NAME="${YC_SA_PROFILE_NAME_PREPROD}"
    YCP_SA_PROFILE_NAME="${YCP_SA_PROFILE_NAME_PREPROD}"
elif [ "${YC_STAGE}" = "${YC_STAGE_TESTING}" ];
then
    TFVARS_FILE_NAME="${TFVARS_FILE_NAME_TESTING}"
    YC_SA_PROFILE_NAME="${YC_SA_PROFILE_NAME_TESTING}"
    YCP_SA_PROFILE_NAME="${YCP_SA_PROFILE_NAME_TESTING}"
else
    echo "ERROR: Unknown YC Stage \"${YC_STAGE}\"."
    echo "${USAGE}"
    exit 1
fi


if [ "${TERRAFORM_COMMAND[0]%% *}" = "init" ];
then
    terraform init
else
    yc config profile activate "${YC_SA_PROFILE_NAME}"
    TF_VAR_env_iam_token=$(yc iam create-token) \
    TF_VAR_env_ycp_sa_profile_name="${YCP_SA_PROFILE_NAME}" \
    terraform "${TERRAFORM_COMMAND[@]}" -var-file="${TFVARS_FILE_NAME}"
fi
