# Values that come from environment variables 'TF_VAR_*'.
variable "env_iam_token" {
  type = string
}

variable "env_ycp_sa_profile_name" {
  type = string
}

# All other variables are passed through -var-file parameter, one of .tfvars files.
variable "cloud" {
  type = object({
    cloud_id  = string
    folder_id = string
  })
}

variable "provider_yandex" {
  type = object({
    endpoint         = string
    storage_endpoint = string
  })
}

# Module-specific variables.
variable "tfstate_s3_kms_master_key" {
  type = object({
    name              = string
    description       = string
    default_algorithm = string
  })
}

variable "tfstate_s3_sa_static_key" {
  type = object({
    service_account_id = string
    description        = string
  })
}

variable "tfstate_s3_storage" {
  type = object({
    bucket        = string
    sse_algorithm = string
  })
}

variable "yav_secret" {
  type = object({
    name                     = string
    comment                  = string
    permissions              = string
    tags                     = string
    payload_storage_endpoint = string
  })
}
