cloud = {
  cloud_id  = "yc.wall-e.cloud"
  folder_id = "yc.wall-e.main-folder"
  region    = "ru-central1"
}

service_accounts = {
  main_sa_id      = "yc.wall-e.main-sa"
  mk8s_sa_id      = "yc.wall-e.mk8s-sa"
  mk8s_node_sa_id = "yc.wall-e.mk8s-node-sa"
}

provider_yandex = {
  endpoint         = "api.cloud-preprod.yandex.net:443"
  storage_endpoint = "storage.cloud-preprod.yandex.net:443"
}

web_ssl_certs_domains = {
  api        = "wall-e.cloud-preprod.yandex.net"
  ui = "wall-e-preprod.cloud.yandex.ru"
  # ui_testing = "wall-e-testing.cloud.yandex.ru"
}


walle_preprod_api = {
  ip_address_name = "walle-preprod-api"
  dns_record_name = "api"
}

walle_preprod_ui = {
  ip_address_name = "walle-preprod-ui"
}

walle_testing_ui = {
  ip_address_name = "walle-testing-ui"
}

kube_socat = {
  ip_address_name = "walle-mk8s-cluster-kube-socat"
  dns_record_name = "walle-mk8s-cluster-kube-socat"
}

walle_dns_zone_id = "aet6on2esfbb84s6c991" # CLOUD-81563 wall-e.cloud-preprod.yandex.net.

# YCLOUD-3836 Network and subnets.
main_network = {
  name = "cloud-walle-preprod-nets"
}

main_subnets = {
  # Egress NAT enabled via CLOUD-89462.
  subnets = {
    cloud-walle-preprod-nets-ru-central1-a = {
      name              = "cloud-walle-preprod-nets-ru-central1-a"
      zone_id           = "ru-central1-a"
      ipv4_subnets      = ["172.16.0.0/16"]
      ipv6_subnets      = ["2a02:6b8:c0e:501:0:fc6c:f2c:0/112"]
      egress_nat_enable = true
    }
    cloud-walle-preprod-nets-ru-central1-b = {
      name              = "cloud-walle-preprod-nets-ru-central1-b"
      zone_id           = "ru-central1-b"
      ipv4_subnets      = ["172.17.0.0/16"]
      ipv6_subnets      = ["2a02:6b8:c02:901:0:fc6c:f2c:0/112"]
      egress_nat_enable = true
    }
    cloud-walle-preprod-nets-ru-central1-c = {
      name              = "cloud-walle-preprod-nets-ru-central1-c"
      zone_id           = "ru-central1-c"
      ipv4_subnets      = ["172.18.0.0/16"]
      ipv6_subnets      = ["2a02:6b8:c03:501:0:fc6c:f2c:0/112"]
      egress_nat_enable = true
    }
  }
}

# Docker container registry settings.
walle_registry = {
  name   = "wall-e-registry"
  subnet = "2a0d:d6c1::/32" // Preprod subnet, Used in egress rules.
}

mk8s_cluster_kms_key_name = "walle-mk8s-encryption-key"
mk8s_cluster_settings = {
  name            = "walle-mk8s-preprod-testing-cluster"
  version         = "1.21"
  release_channel = "REGULAR"
}

preprod_mk8s_nodegroup_settings = {
  name = "walle-mk8s-preprod-nodegroup"
  size = 3
}

testing_mk8s_nodegroup_settings = {
  name = "walle-mk8s-testing-nodegroup"
  size = 3
}

mk8s_nodegroup_instance_template_settings = {
  platform_id = "standard-v3"
  metadata = {
    ssh_keys_file_path = "../oslogin-ssh-keys.txt"
  }
  boot_disk = {
    size = 32
    type = "network-hdd"
  }
  resources = {
    core_fraction = 100
    cores         = 4
    memory        = 16
  }
}

main_mongodb_password_secret = {
  secret_id   = "sec-01g609f79bh70ckpesc1z9jant" # yc-walle-preprod-lockbox-secrets
  secret_name = "main-mongodb-password"
}
