cloud = {
  cloud_id  = "yc.wall-e.cloud"
  folder_id = "yc.wall-e.main-folder"
  region    = "ru-central1"
}

service_accounts = {
  main_sa_id      = "yc.wall-e.main-sa"
  mk8s_sa_id      = "yc.wall-e.mk8s-sa"
  mk8s_node_sa_id = "yc.wall-e.mk8s-node-sa"
}

provider_yandex = {
  endpoint         = "api.cloud.yandex.net:443"
  storage_endpoint = "storage.yandexcloud.net:443"
}

web_ssl_certs_domains = {
  api = "wall-e.cloud.yandex.net"
  ui  = "wall-e.cloud.yandex.ru"
}

walle_api = {
  ip_address_name = "walle-api"
  dns_record_name = "api"
}

walle_ui = {
  ip_address_name = "walle-ui"
}

kube_socat = {
  ip_address_name = "walle-mk8s-cluster-kube-socat"
  dns_record_name = "walle-mk8s-cluster-kube-socat"
}

walle_dns_zone_id = "dns0j2vr7lth0a6nq4tu" # CLOUD-78892 wall-e.cloud.yandex.net.

# YCLOUD-3725 Network and subnets.
main_network = {
  name = "cloud-walle-prod-nets"
}

main_subnets = {
  # Egress NAT enabled via CLOUD-89462.
  subnets = {
    cloud-walle-prod-nets-ru-central1-a = {
      name              = "cloud-walle-prod-nets-ru-central1-a"
      zone_id           = "ru-central1-a"
      ipv4_subnets      = ["172.16.0.0/16"]
      ipv6_subnets      = ["2a02:6b8:c0e:500:0:f882:33e2:0/112"]
      egress_nat_enable = true
    }
    cloud-walle-prod-nets-ru-central1-b = {
      name              = "cloud-walle-prod-nets-ru-central1-b"
      zone_id           = "ru-central1-b"
      ipv4_subnets      = ["172.17.0.0/16"]
      ipv6_subnets      = ["2a02:6b8:c02:900:0:f882:33e2:0/112"]
      egress_nat_enable = true
    }
    cloud-walle-prod-nets-ru-central1-c = {
      name              = "cloud-walle-prod-nets-ru-central1-c"
      zone_id           = "ru-central1-c"
      ipv4_subnets      = ["172.18.0.0/16"]
      ipv6_subnets      = ["2a02:6b8:c03:500:0:f882:33e2:0/112"]
      egress_nat_enable = true
    }
  }
}

# Docker container registry settings.
walle_registry = {
  name   = "wall-e-registry"
  subnet = "2a0d:d6c1::/32" // Used in egress rules.
}

mk8s_cluster_kms_key_name = "walle-mk8s-encryption-key"
mk8s_cluster_settings = {
  name            = "walle-mk8s-cluster"
  version         = "1.21"
  release_channel = "REGULAR"
}

mk8s_nodegroup_settings = {
  name = "walle-mk8s-nodegroup"
  size = 6
}
mk8s_nodegroup_instance_template_settings = {
  platform_id = "standard-v3"
  metadata = {
    ssh_keys_file_path = "../oslogin-ssh-keys.txt"
  }
  boot_disk = {
    size = 32
    type = "network-hdd"
  }
  resources = {
    core_fraction = 100
    cores         = 4
    memory        = 16
  }
}

main_mongodb_password_secret = {
  secret_id   = "sec-01g4x0rp7g30d2p2tva4j78j25" # yc-walle-prod-lockbox-secrets
  secret_name = "main-mongodb-password"
}
