import os
from infra.walle.database.clients.s3_mds_client import S3Client, format_file_item
from infra.walle.database.backup_storage.base_storage import MongoBackupBaseStorage


class MongoBackupS3Storage(MongoBackupBaseStorage):

    def __init__(self, host, rs_name, tmp_dir, s3_url, bucket, access_key, secret_key):
        self.s3 = S3Client(access_key, secret_key, s3_url)
        self.bucket = bucket
        super(MongoBackupS3Storage, self).__init__(host, rs_name, tmp_dir)

    def _list(self):
        req_result = self.s3.request("get", self.bucket).content
        return self.s3.return_list(req_result, path="Contents", formatter=format_file_item)

    def _store(self, filename, filepath):
        data = open(filepath, 'rb')
        with data:
            return self.s3.request("put", self.bucket, filename, data)

    def _del(self, name):
        self.s3.request("delete", self.bucket, name)

    def _get(self, name):
        target_path = os.path.join(self.root_dir, name)
        if os.path.exists(target_path):
            return target_path
        with open(target_path, 'wb') as fs:
            fs.write(self.s3.request("get", self.bucket, name).content)
        return target_path
