import json
import requests


class CheckStatus:

    OK = "OK"
    WARN = "WARN"
    CRIT = "CRIT"


def notify_event(host, port, rs_name, rs_check, status_str, event_description):
    url = "http://localhost:31579/events"
    payload = {
        "events": [
            {
                "host": host,
                "instance": f"{port}",
                "service": f"mongo-rs-{rs_name}-{rs_check}",
                "status": status_str,
                "tags": [
                    "mongodb",
                    "wall-e.srv"
                ],
                "description": event_description
            }
        ]
    }
    headers = {
        'content-type': "application/json"
    }
    response = requests.request("POST", url, data=json.dumps(payload), headers=headers)
    if not response.ok:
        raise Exception("Notify juggler failed with error:", response.reason, "Payload:", payload)


def notify_backup_completed(host, port, rs_name):
    notify_event(host, port, rs_name, "backup",
                 "OK", f"Backup for {rs_name} replica set from {host}:{port} instance completed")
