import argparse
from infra.walle.database.mongo_config import MongoConfig
from infra.walle.database.mongo_backup_restore.mongo_backup_daemon import MongoBackupDaemon
from infra.walle.database.util import add_subcommand
import logging

logging.basicConfig(level=logging.INFO)


def _daemon(args):
    config = MongoConfig(args)
    daemon = MongoBackupDaemon(config)
    daemon.run()


def _once(args):
    config = MongoConfig(args)
    daemon = MongoBackupDaemon(config)
    daemon.run_once()


def main():
    root_parser = argparse.ArgumentParser(description='Wall-e mongo backup daemon.')
    root_parser.set_defaults(func=root_parser.print_help)

    sub = root_parser.add_subparsers(required=True, dest="subcommand")
    add_subcommand(sub, "daemon", _daemon, "Starts backup daemon")
    add_subcommand(sub, "once", _once, "Runs backup routine once")
    args = root_parser.parse_args()
    args.func(args)


if __name__ == "__main__":
    main()

