from infra.walle.database.mongo_config import MongoConfig
from infra.walle.database.backup_storage.backup_storage_s3 import MongoBackupS3Storage
from infra.walle.database.backup_storage.backup_storage_local import MongoBackupLocalStorage
from infra.walle.database.clients.mongo_tools import restore
import logging

log = logging.getLogger(__name__)


class MongoBackupRestorer:

    def __init__(self, config: MongoConfig):
        self.config = config
        self.s3_storage = MongoBackupS3Storage(
            self.config.self_host,
            self.config.mongo_rs_name,
            tmp_dir=self.config.local_storage,
            s3_url=self.config.s3_url,
            bucket=self.config.s3_bucket,
            access_key=self.config.s3_access_key,
            secret_key=self.config.s3_secret_key
        )

        self.local_storage = MongoBackupLocalStorage(
            self.config.self_host,
            self.config.mongo_rs_name,
            root_dir=self.config.local_storage
        )

    def list_l3(self):
        return self.s3_storage.list()

    def list_local(self):
        return self.local_storage.list()

    def restore(self, backup, ns_include=None, ns_exclude=None):
        log.info("Retrieving backup file: {}".format(backup))
        path = backup.get()
        log.info("Backup file retrieved: {}".format(path))
        log.info("Restoring databases: {} to {}:{}".format(path, self.config.self_host, self.config.self_port))
        restore(path, self.config.mongorestore_path, host=self.config.self_host, port=self.config.self_port,
                include=ns_include, exclude=ns_exclude, username=self.config.mongo_username,
                password=self.config.mongo_password, authentication_database=self.config.mongo_admin_db)
        log.info("Done".format(path))




