import json
import os
import socket


HOUR_SECONDS = 3600


class MongoConfig:

    def __init__(self, args):
        if args.config:
            with open(args.config, "r") as f:
                self.config_data = json.load(f)
        else:
            self.config_data = {}

        self.mongo_username = self.config_data.get("mongo_username", None)
        self.mongo_password = self.config_data.get("mongo_password", None)
        self.mongo_rs_name = self.config_data.get("mongo_rs_name", None)
        self.mongo_admin_db = self.config_data.get("mongo_admin_db", "admin")

        self.mongodump_path = self.config_data.get("mongodump_path", "mongodump")
        self.mongorestore_path = self.config_data.get("mongorestore_path", "mongorestore")

        self.self_host = os.environ.get("HOSTNAME", socket.gethostname())
        self.self_port = int(os.environ.get("BSCONFIG_IPORT", self.config_data.get("mongo_port", 27017)))

        self.max_oplag = int(self.config_data.get("max_oplag", 7200))

        self.tmp_path = self.config_data.get("tmp_path", "/tmp")

        self.local_storage = self.config_data.get("local_storage")

        self.s3_url = self.config_data.get("s3_url")
        self.s3_bucket = self.config_data.get("s3_bucket")
        self.s3_access_key = self.config_data.get("s3_access_key")
        self.s3_secret_key = self.config_data.get("s3_secret_key")

        self.backup_period = self.config_data.get("backup_period", 12 * HOUR_SECONDS)

        if hasattr(args, "no_auth") and args.no_auth:
            self.mongo_username = None
            self.mongo_password = None
            self.mongo_admin_db = None

        if hasattr(args, "rs") and args.rs:
            self.mongo_rs_name = args.rs

        if hasattr(args, "host") and args.host:
            self.self_host = args.host

        if hasattr(args, "port") and args.port:
            self.self_port = args.port
