import argparse
from infra.walle.database.mongo_config import MongoConfig
from infra.walle.database.monitor.monitor import MongoMonitor
from infra.walle.database.util import add_subcommand


def _checks(args):
    for check, status, description in MongoMonitor(MongoConfig(args)).return_statuses():
        print(f"{check} {status}: {description}")


def _monitor(args):
    if MongoMonitor(MongoConfig(args)).monitor():
        exit(0)
    else:
        exit(1)


def main():
    root_parser = argparse.ArgumentParser(description='Wall-e monitor script.')
    root_parser.set_defaults(func=root_parser.print_help)
    sub = root_parser.add_subparsers(required=True, dest="subcommand")
    add_subcommand(sub, "checks", _checks, "Shows checks statuses")
    add_subcommand(sub, "monitor", _monitor, "Sends check statuses to juggler and returns code")
    args = root_parser.parse_args()
    args.func(args)


if __name__ == "__main__":
    main()
