
def pretty_print(text):
    print(text)


def add_subcommand(subparsers, name, action, help):
    parser = subparsers.add_parser(name, description=help, help=help)
    parser.set_defaults(func=action)
    parser.add_argument('-c', '--config', type=str,
                        dest="config",
                        nargs='?',
                        default='/etc/mongo_scripts.json',
                        help='Config file (default '
                             '/etc/mongo_scripts.json)')
    parser.add_argument('--rs', type=str, dest="rs", nargs='?', default=None,
                        help="Override config's replica set name")
    parser.add_argument("-n", "--no-auth", action='store_true',
                        dest="no_auth", help="Don't use login and password on mongo")
    return parser
