import subprocess
from sepelib.core import config
from IPython.core.magic import register_line_magic


@register_line_magic
def mongo(line):
    _run_mongo_shell("mongodb.uri", line)


@register_line_magic
def mongo_health(line):
    _run_mongo_shell("health-mongodb.uri", line)


def _run_mongo_shell(conn_str_option, expr_to_eval=None):
    run_args = ["mongo", "--ipv6", "--quiet", "{}".format(config.get_value(conn_str_option))]
    if expr_to_eval:
        run_args.extend(["--eval", expr_to_eval])
    else:
        run_args.extend(["--shell"])

    subprocess.call(run_args)
